/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.partitionrefinement;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.simple.SimpleDeterministicAutomaton;
import net.automatalib.util.partitionrefinement.AutomatonInitialPartitioning;
import net.automatalib.util.partitionrefinement.Block;
import net.automatalib.util.partitionrefinement.PaigeTarjan;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PaigeTarjanInitializers {
    private PaigeTarjanInitializers() {
    }

    public static void initCompleteDeterministic(PaigeTarjan pt, UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> absAutomaton, AutomatonInitialPartitioning ip, boolean pruneUnreachable) {
        PaigeTarjanInitializers.initCompleteDeterministic(pt, absAutomaton, ip.initialClassifier(absAutomaton), pruneUnreachable);
    }

    public static void initCompleteDeterministic(PaigeTarjan pt, SimpleDeterministicAutomaton.FullIntAbstraction absAutomaton, IntFunction<?> initialClassification, boolean pruneUnreachable) {
        if (pruneUnreachable) {
            PaigeTarjanInitializers.initCompleteDeterministicPrune(pt, absAutomaton, initialClassification);
        } else {
            PaigeTarjanInitializers.initCompleteDeterministicNoPrune(pt, absAutomaton, initialClassification);
        }
    }

    private static void initCompleteDeterministicPrune(PaigeTarjan pt, SimpleDeterministicAutomaton.FullIntAbstraction absAutomaton, IntFunction<?> initialClassification) {
        int numStates = absAutomaton.size();
        int numInputs = absAutomaton.numInputs();
        int posDataLow = numStates;
        int predOfsDataLow = posDataLow + numStates;
        int numTransitions = numStates * numInputs;
        int predDataLow = predOfsDataLow + numTransitions + 1;
        int dataSize = predDataLow + numTransitions;
        int[] data = new int[dataSize];
        Block[] blockForState = new Block[numStates];
        HashMap<@Nullable Object, Block> blockMap = new HashMap<Object, Block>();
        int init = absAutomaton.getIntInitialState();
        Object initClass = initialClassification.apply(init);
        Block initBlock = pt.createBlock();
        initBlock.high = 1;
        blockForState[init] = initBlock;
        blockMap.put(initClass, initBlock);
        int[] statesBuff = new int[numStates];
        statesBuff[0] = init;
        int statesPtr = 0;
        int reachableStates = 1;
        while (statesPtr < reachableStates) {
            int curr = statesBuff[statesPtr++];
            int predCountBase = predOfsDataLow;
            for (int i = 0; i < numInputs; ++i) {
                int succ = absAutomaton.getSuccessor(curr, i);
                if (succ < 0) {
                    throw new IllegalArgumentException("Automaton must not be partial");
                }
                Block succBlock = blockForState[succ];
                if (succBlock == null) {
                    Object succClass = initialClassification.apply(succ);
                    blockForState[succ] = PaigeTarjanInitializers.getOrCreateSuccBlock(blockMap, succClass, pt);
                    statesBuff[reachableStates++] = succ;
                }
                int n = predCountBase + succ;
                data[n] = data[n] + 1;
                predCountBase += numStates;
            }
        }
        pt.canonizeBlocks();
        int n = predOfsDataLow;
        data[n] = data[n] + predDataLow;
        PaigeTarjanInitializers.prefixSum(data, predOfsDataLow, predDataLow);
        for (int i = 0; i < reachableStates; ++i) {
            int stateId = statesBuff[i];
            Block b = blockForState[stateId];
            int pos = --b.low;
            data[pos] = stateId;
            data[posDataLow + stateId] = pos;
            int predOfsBase = predOfsDataLow;
            for (int j = 0; j < numInputs; ++j) {
                int succ = absAutomaton.getSuccessor(stateId, j);
                assert (succ >= 0);
                int n2 = predOfsBase + succ;
                int n3 = data[n2] - 1;
                data[n2] = n3;
                data[n3] = stateId;
                predOfsBase += numStates;
            }
        }
        pt.setBlockData(data);
        pt.setPosData(data, posDataLow);
        pt.setPredOfsData(data, predOfsDataLow);
        pt.setPredData(data);
        pt.setBlockForState(blockForState);
        pt.setSize(numStates, numInputs);
    }

    private static void initCompleteDeterministicNoPrune(PaigeTarjan pt, SimpleDeterministicAutomaton.FullIntAbstraction absAutomaton, IntFunction<?> initialClassification) {
        int i;
        int numStates = absAutomaton.size();
        int numInputs = absAutomaton.numInputs();
        int posDataLow = numStates;
        int predOfsDataLow = posDataLow + numStates;
        int numTransitions = numStates * numInputs;
        int predDataLow = predOfsDataLow + numTransitions + 1;
        int dataSize = predDataLow + numTransitions;
        int[] data = new int[dataSize];
        Block[] blockForState = new Block[numStates];
        HashMap<@Nullable Object, Block> blockMap = new HashMap<Object, Block>();
        for (i = 0; i < numStates; ++i) {
            Object classification = initialClassification.apply(i);
            blockForState[i] = PaigeTarjanInitializers.getOrCreateSuccBlock(blockMap, classification, pt);
            int predCountBase = predOfsDataLow;
            for (int j = 0; j < numInputs; ++j) {
                int succ = absAutomaton.getSuccessor(i, j);
                if (succ < 0) {
                    throw new IllegalArgumentException("Automaton must not be partial");
                }
                int n = predCountBase + succ;
                data[n] = data[n] + 1;
                predCountBase += numStates;
            }
        }
        pt.canonizeBlocks();
        int n = predOfsDataLow;
        data[n] = data[n] + predDataLow;
        PaigeTarjanInitializers.prefixSum(data, predOfsDataLow, predDataLow);
        for (i = 0; i < numStates; ++i) {
            Block b = blockForState[i];
            int pos = --b.low;
            data[pos] = i;
            data[posDataLow + i] = pos;
            int predOfsBase = predOfsDataLow;
            for (int j = 0; j < numInputs; ++j) {
                int succ = absAutomaton.getSuccessor(i, j);
                assert (succ >= 0);
                int n2 = predOfsBase + succ;
                int n3 = data[n2] - 1;
                data[n2] = n3;
                data[n3] = i;
                predOfsBase += numStates;
            }
        }
        pt.setBlockData(data);
        pt.setPosData(data, posDataLow);
        pt.setPredOfsData(data, predOfsDataLow);
        pt.setPredData(data);
        pt.setBlockForState(blockForState);
        pt.setSize(numStates, numInputs);
    }

    public static void prefixSum(int[] array, int startInclusive, int endExclusive) {
        Arrays.parallelPrefix(array, startInclusive, endExclusive, Integer::sum);
    }

    public static void initDeterministic(PaigeTarjan pt, SimpleDeterministicAutomaton.FullIntAbstraction absAutomaton, IntFunction<?> initialClassification, Object sinkClassification) {
        int numStatesWithSink;
        int numStates = absAutomaton.size();
        int numInputs = absAutomaton.numInputs();
        int sinkId = numStates;
        int posDataLow = numStatesWithSink = numStates + 1;
        int predOfsDataLow = posDataLow + numStatesWithSink;
        int numTransitionsFull = numStatesWithSink * numInputs;
        int predDataLow = predOfsDataLow + numTransitionsFull + 1;
        int dataSize = predDataLow + numTransitionsFull;
        int[] data = new int[dataSize];
        Block[] blockForState = new Block[numStatesWithSink];
        HashMap<@Nullable Object, Block> blockMap = new HashMap<Object, Block>();
        int initId = absAutomaton.getIntInitialState();
        Object initClass = initialClassification.apply(initId);
        Block initBlock = pt.createBlock();
        initBlock.high = 1;
        blockForState[initId] = initBlock;
        blockMap.put(initClass, initBlock);
        int[] statesBuff = new int[numStatesWithSink];
        statesBuff[0] = initId;
        int statesPtr = 0;
        int reachableStates = 1;
        boolean partial = false;
        while (statesPtr < reachableStates) {
            int currId;
            if ((currId = statesBuff[statesPtr++]) == sinkId) continue;
            int predCountBase = predOfsDataLow;
            for (int i = 0; i < numInputs; ++i) {
                int succId;
                int succ = absAutomaton.getSuccessor(currId, i);
                if (succ < 0) {
                    succId = sinkId;
                    partial = true;
                } else {
                    succId = succ;
                }
                Block succBlock = blockForState[succId];
                if (succBlock == null) {
                    Object succClass = succ < 0 ? sinkClassification : initialClassification.apply(succ);
                    blockForState[succId] = PaigeTarjanInitializers.getOrCreateSuccBlock(blockMap, succClass, pt);
                    statesBuff[reachableStates++] = succId;
                }
                int n = predCountBase + succId;
                data[n] = data[n] + 1;
                predCountBase += numStatesWithSink;
            }
        }
        if (partial) {
            int predCountIdx = predOfsDataLow + sinkId;
            for (int i = 0; i < numInputs; ++i) {
                int n = predCountIdx;
                data[n] = data[n] + 1;
                predCountIdx += numStatesWithSink;
            }
        }
        pt.canonizeBlocks();
        int n = predOfsDataLow;
        data[n] = data[n] + predDataLow;
        PaigeTarjanInitializers.prefixSum(data, predOfsDataLow, predDataLow);
        for (int i = 0; i < reachableStates; ++i) {
            int stateId = statesBuff[i];
            Block b = blockForState[stateId];
            int pos = --b.low;
            data[pos] = stateId;
            data[posDataLow + stateId] = pos;
            int predOfsBase = predOfsDataLow;
            for (int j = 0; j < numInputs; ++j) {
                int succ;
                int succId = stateId == sinkId ? sinkId : ((succ = absAutomaton.getSuccessor(stateId, j)) < 0 ? sinkId : succ);
                int n2 = predOfsBase + succId;
                int n3 = data[n2] - 1;
                data[n2] = n3;
                data[n3] = stateId;
                predOfsBase += numStatesWithSink;
            }
        }
        pt.setBlockData(data);
        pt.setPosData(data, posDataLow);
        pt.setPredOfsData(data, predOfsDataLow);
        pt.setPredData(data);
        pt.setSize(numStatesWithSink, numInputs);
        pt.setBlockForState(blockForState);
        pt.removeEmptyBlocks();
    }

    private static Block getOrCreateSuccBlock(Map<@Nullable Object, Block> blockMap, Object classification, PaigeTarjan pt) {
        Block block = blockMap.get(classification);
        if (block == null) {
            block = pt.createBlock();
            block.high = 0;
            blockMap.put(classification, block);
        }
        ++block.high;
        return block;
    }
}

