#!/bin/bash

# Define the vectors
sample_sizes=("1000")
graph_sizes=("medium" "large20")
graph_densities=("cluster")
methods=("random")
task="standardized"
noise="nonlin_strong"
graph_type="GRP"

# Initialize an empty array to store the data configurations
data_configs=()

# Loop through the Cartesian product of the vectors and concatenate the arguments
for n_samples in "${sample_sizes[@]}"
do
    for graph_size in "${graph_sizes[@]}"
    do 
        for density in "${graph_densities[@]}"
        do
            data_configs+=("$n_samples"_"$graph_size"_"$density")
        done
    done
done

# Run python script
for config in "${data_configs[@]}"
do
    for method in "${methods[@]}"
    do
        python -m slurm.slurm_single_config --method "$method" --scenario linear --scenario_param linear_0.33 --partition cpu\
        --graph_type "$graph_type" --task "$task" --noise "$noise" --data_config "$config"
    done
done
