## Block Coordinate Plug-and-Play Methods for Blind Inverse Problems

Plug-and-play (PnP) prior is a well-known class of methods for solving imaging inverse problems by computing fixed-points of operators combining physical measurement models and learned image denoisers. While PnP methods have been extensively used for image recovery with known measurement operators, there is little work on PnP for solving blind inverse problems. We address this gap by presenting a new block-coordinate PnP (BC-PnP) method that efficiently solves this joint estimation problem by introducing learned denoisers as priors on both the unknown image and the unknown measurement operator. We present a new convergence theory for BC-PnP compatible with blind inverse problems by considering nonconvex data-fidelity terms and expansive denoisers. Our theory analyzes the convergence of BC-PnP to a stationary point of an implicit function associated with an approximate minimum mean-squared error (MMSE) denoiser. We numerically validate our method on two blind inverse problems: automatic coil sensitivity estimation in magnetic resonance imaging (MRI) and blind image deblurring. Our results show that BC-PnP provides an efficient and principled framework for using denoisers as PnP priors for jointly estimating measurement operators and images.

## How to run the code

### Download the dataset and pre-trained denoiser from the following link and put them into the folders `./data` and `./network`

[https://bit.ly/41PPf6j](https://bit.ly/41PPf6j)

### Prepare the environment

It is better to first use Conda to set up a new environment by running 

``conda env create --file "requirement.yml" -n bcpnp``

and 

``conda activate bcpnp``

### Run the BCPnP testing on MRI reconstruction

``./run.sh GPU_INDEX``

The results can be found at the folder `./result`.
