# Training Artifacts

This directory contains the output circuit designs generated during the training process for the three design tasks. The artifacts represent the final ~10 iterations of unablated training for each circuit design task. 10 iterations is due to supplementary material size constraints.


### Circuit Netlists (`.scs` files)

Circuit netlist files follow this naming pattern:

```
<design_task>_defaultrun<gpu_id>_stack<rank>_itr<iteration>_traj<trajectory>_step<step>_<timestamp>.scs
```

Where:
- `<design_task>`: One of `ring_oscillator`, `AAA_Comp_SA`, or `opamp_extra_biases`
- `<gpu_id>`: GPU identifier used for training
- `<rank>`: Multiprocessing rank
- `<iteration>`: Training iteration number
- `<trajectory>`: Trajectory number within the iteration
- `<step>`: Step number within the trajectory
- `<timestamp>`: Date and time in `Y-m-d-h-m-s` format

### Results Files (`.yaml` files)

Each circuit netlist has a corresponding results file with the naming pattern:

```
result_defaultrun<gpu_id>_stack<rank>_itr<iteration>_traj<trajectory>_step<step>_<timestamp>.yaml
```

The parameters follow the same convention as the circuit netlist files.
