"""
Implement the agent coordinator.
"""
from util import transform_to_2d
import numpy as np
import GPy


class Coordinator():

    def __init__(self, coordinator_config):

        self.num_agents = coordinator_config['num_agents']
        self.agent_list = coordinator_config['agent_list']
        self.num_blackbox_constraints = \
            coordinator_config['num_blackbox_constraints']
        self.num_affine_constraints = \
            coordinator_config['num_affine_constraints']

        self.blackbox_dual = np.zeros(
            self.num_blackbox_constraints
        )
        self.affine_dual = np.zeros(
            self.num_affine_constraints
        )
        self.epsilon = coordinator_config['epsilon']
        self.affine_b = coordinator_config['affine_b']

        self.whole_dim = coordinator_config['whole_dim']
        self.total_grid = coordinator_config['total_grid']
        self.whole_black_box_funcs = \
            coordinator_config['whole_black_box_funcs']

        self.opt_val = coordinator_config['opt_val']
        self.opt_sol = coordinator_config['opt_sol']


    def primal_update(self, eval_and_udt=True):
        # using current dual variables to coordinate the local primal updates
        local_Ax_sum = 0
        local_constr_lg_sum = 0

        for k in range(self.num_agents):
            bo_agent = self.agent_list[k]
            local_Ax, lowerg = bo_agent.local_primal_update(
                self.blackbox_dual, self.affine_dual, eval_and_udt=eval_and_udt
            )
            local_Ax_sum += local_Ax
            local_constr_lg_sum += lowerg

        return local_Ax_sum, local_constr_lg_sum

    def dual_update(self, local_Ax_sum, local_constr_lg_sum):
        # update the dual variable
        self.blackbox_dual += (local_constr_lg_sum + self.epsilon)
        self.affine_dual += (local_Ax_sum - self.affine_b)

    def update(self):
        local_Ax_sum, local_constr_lg_sum = self.primal_update()
        self.dual_update(local_Ax_sum, local_constr_lg_sum)

