from random_bo_agent_config import *
from coordinator import Coordinator
from random_instance import RandomInstance
import datetime
import pickle

def get_result():
    random_inst = RandomInstance()
    random_coordinator, cei_rc = random_inst.run_one_instance()

    agent_list = random_coordinator.agent_list
    num_agent = len(agent_list)
    obj = sum(agent_list[k].black_box_func_gp_list[0].Y
              for k in range(num_agent))
    constr_1 = sum(agent_list[k].black_box_func_gp_list[1].Y
                   for k in range(num_agent))
    constr_2 = sum(agent_list[k].black_box_func_gp_list[2].Y
                   for k in range(num_agent))
    opt_val = random_coordinator.opt_val
    regret = obj - opt_val

    agent_list = cei_rc.agent_list
    num_agent = len(agent_list)
    cei_obj = sum(agent_list[k].black_box_func_gp_list[0].Y
                  for k in range(num_agent))
    cei_constr_1 = sum(agent_list[k].black_box_func_gp_list[1].Y
                       for k in range(num_agent))
    cei_constr_2 = sum(agent_list[k].black_box_func_gp_list[2].Y
                       for k in range(num_agent))
    opt_val = cei_rc.opt_val
    cei_regret = cei_obj - opt_val

    inv_opt_val = cei_rc.coordinator_config['inv_opt_val']
    cond_small = (inv_opt_val > opt_val)
    return regret, constr_1, constr_2, cei_regret, cei_constr_1, cei_constr_2,\
        cond_small

instance_num = 100

regret_list = []
constr_1_list = []
constr_2_list = []

cei_regret_list = []
cei_constr_1_list = []
cei_constr_2_list = []

cond_small_list = []
for k in range(instance_num):
    regret, constr_1, constr_2, cei_regret, cei_constr_1, cei_constr_2, \
        cond_small = get_result()

    regret_list.append(regret)
    constr_1_list.append(constr_1)
    constr_2_list.append(constr_2)

    cei_regret_list.append(cei_regret)
    cei_constr_1_list.append(cei_constr_1)
    cei_constr_2_list.append(cei_constr_2)

    cond_small_list.append(cond_small)

now_time_str = datetime.datetime.now().strftime(
        "%H_%M_%S-%b_%d_%Y")

with open(f'./result/sample_{now_time_str}.pkl', 'wb') as f:
    pickle.dump([
        regret_list,
        constr_1_list,
        constr_2_list,
        cei_regret_list,
        cei_constr_1_list,
        cei_constr_2_list,
        cond_small_list
    ], f)
