from random_bo_agent_config import *
from coordinator import Coordinator
from power_allocation_instance import PowerAllocationInstance
import datetime
import pickle

def get_result():
    pa_inst = PowerAllocationInstance()
    random_coordinator, penalty_pac = pa_inst.run_one_instance()

    agent_list = random_coordinator.agent_list
    num_agent = len(agent_list)
    obj = sum(agent_list[k].black_box_func_gp_list[0].Y
              for k in range(num_agent))
    constr_1 = sum(agent_list[k].black_box_func_gp_list[0].X
                   for k in range(num_agent)) - random_coordinator.affine_b
    opt_val = random_coordinator.opt_val
    regret = obj - opt_val

    agent_list = penalty_pac.agent_list
    num_agent = len(agent_list)
    penalty_obj = sum(agent_list[k].black_box_func_gp_list[0].Y
                  for k in range(num_agent))
    penalty_constr_1 = sum(agent_list[k].black_box_func_gp_list[0].X
                       for k in range(num_agent)) - penalty_pac.affine_b
    opt_val = penalty_pac.opt_val
    penalty_regret = penalty_obj - opt_val

    avg_obj = random_coordinator.coordinator_config['obj_avg_sol']

    rho = agent_list[0].rho
    return regret, constr_1, penalty_regret, penalty_constr_1, avg_obj, \
        rho, num_agent


instance_num = 100

regret_list = []
constr_1_list = []

penalty_regret_list = []
penalty_constr_1_list = []

obj_avg_sol_list = []

for k in range(instance_num):
    regret, constr_1, penalty_regret, penalty_constr_1, avg_obj, rho, \
        num_agent = get_result()
    regret_list.append(regret)
    constr_1_list.append(constr_1)

    penalty_regret_list.append(penalty_regret)
    penalty_constr_1_list.append(penalty_constr_1)

    obj_avg_sol_list.append(avg_obj)

now_time_str = datetime.datetime.now().strftime(
        "%H_%M_%S-%b_%d_%Y")

with open(f'./result/pa_sample_{now_time_str}_{rho}_{num_agent}.pkl', 'wb') \
    as f:
    pickle.dump([
        regret_list,
        constr_1_list,
        penalty_regret_list,
        penalty_constr_1_list,
        obj_avg_sol_list
    ], f)
