"""
Implement the agent coordinator.
"""
from util import transform_to_2d
from random_bo_agent_config import get_random_agent_config
from bo_agent import BO_AGENT
from coordinator import Coordinator
import numpy as np
import GPy
import itertools


class RandomInstance():

    def __init__(self):

        self.num_agents = 3
        self.run_horizon = 100
        self.M = 1e20

    def generate_one_agent(self):
        random_agent_config = get_random_agent_config()
        random_agent_config['local_A'] = np.zeros(
            random_agent_config['var_dim']
        )

        random_agent_config['acq_type'] = 'primal_dual'
        primal_dual_agent = BO_AGENT(random_agent_config)

        random_agent_config['acq_type'] = 'cei'
        cei_agent = BO_AGENT(random_agent_config)
        return primal_dual_agent, cei_agent

    def generate_one_instance(self):
        coordinator_config = dict()
        coordinator_config['num_agents'] = self.num_agents

        primal_dual_agent_list = []
        cei_agent_list = []
        for k in range(self.num_agents):
            new_primal_dual_agent, new_cei_agent = self.generate_one_agent()
            primal_dual_agent_list.append(new_primal_dual_agent)
            cei_agent_list.append(new_cei_agent)

        agent_0 = primal_dual_agent_list[0]
        coordinator_config['num_blackbox_constraints'] = \
            agent_0.num_black_box_constrs
        coordinator_config['num_affine_constraints'] = 1
        coordinator_config['epsilon'] = 0.2
        coordinator_config['affine_b'] = 0

        coordinator_config['whole_dim'] = self.num_agents * \
            primal_dual_agent_list[0].dim_x
        coordinator_config['total_grid'] = list(itertools.product(
            primal_dual_agent_list[0].x_grid,
            primal_dual_agent_list[1].x_grid,
            primal_dual_agent_list[2].x_grid
        )
        )

        whole_black_box_funcs = []
        #for k in range(agent_0.num_black_box_constrs + 1):
        whole_black_box_funcs.append(
                lambda x: sum(
                primal_dual_agent_list[i].black_box_funcs_list[0](x[i])
                for i in range(self.num_agents))
            )

        whole_black_box_funcs.append(
                lambda x: sum(
                primal_dual_agent_list[i].black_box_funcs_list[1](x[i])
                for i in range(self.num_agents))
            )

        whole_black_box_funcs.append(
                lambda x: sum(
                primal_dual_agent_list[i].black_box_funcs_list[2](x[i])
                for i in range(self.num_agents))
            )



        coordinator_config['whole_black_box_funcs'] = whole_black_box_funcs
        x_grid = primal_dual_agent_list[0].x_grid

        M = self.M

        whole_obj = whole_black_box_funcs[0]
        whole_constraints_list = whole_black_box_funcs[1:]
        constr_func_val = [whole_obj(x) +
                       M * (1 - np.all(
            [whole_constraints_list[k](x) <= 0 for k in range(
                coordinator_config['num_blackbox_constraints'])]
                       )
                       )
                           for x in coordinator_config['total_grid']
                           ]

        opt_val = np.min(constr_func_val)
        opt_val_id = np.argmin(constr_func_val)
        opt_sol = coordinator_config['total_grid'][opt_val_id]
        coordinator_config['opt_val'] = opt_val
        coordinator_config['opt_sol'] = opt_sol


        inv_constr_func_val = [whole_obj(x) +
                       M * (1 - np.any(
            [whole_constraints_list[k](x) > 0 for k in range(
                coordinator_config['num_blackbox_constraints'])]
                       )
                       )
                           for x in coordinator_config['total_grid']
                           ]

        inv_opt_val = np.min(inv_constr_func_val)
        inv_opt_val_id = np.argmin(inv_constr_func_val)
        inv_opt_sol = coordinator_config['total_grid'][inv_opt_val_id]
        coordinator_config['inv_opt_val'] = inv_opt_val
        coordinator_config['inv_opt_sol'] = inv_opt_sol

        coordinator_config['agent_list'] = primal_dual_agent_list
        primal_dual_random_coordinator = Coordinator(coordinator_config)

        coordinator_config['agent_list'] = cei_agent_list
        cei_random_coordinator = Coordinator(coordinator_config)

        return primal_dual_random_coordinator, cei_random_coordinator

    def run_one_instance(self):
        max_while = 50
        num_while = 0
        while num_while <= max_while:
            pd_rc, cei_rc = self.generate_one_instance()
            if pd_rc.opt_val < 0.5 * self.M:
               break
            num_while += 1

        for k in range(self.run_horizon):
            pd_rc.update()

        for k in range(self.run_horizon):
            cei_rc.update()

        return pd_rc, cei_rc
