## 🧠 Token Representation Shrinkage Impairs Creativity of Generative Models

This repository contains the official implementation and experimental code for our paper: 
**"Token Representation Shrinkage Impairs Creativity of Generative Models."** 

We investigate how token representation shrinkage degrades the creative capacity of generative models, and provide experiments on both synthetic and real-world datasets.

---

### 📁 Project Structure

- **`synthetic_exp/`** 
  Code for experiments on synthetic datasets (Section 4.1).

- **`cifar10_exp/`** 
  Experiments on CIFAR-10 to validate the existence of token representation shrinkage (Section 5.2).

- **`generative_model_exp/`** (Section 5.3 and 5.4)
  Experiments on large-scale generative models. It includes:
  - **`Tokenizer/`** 
    Training code for tokenizers (modified from [XQGAN](https://github.com/lxa9867/ImageFolder)).
  
  - **`MaskGIT/`** 
    PyTorch implementation of MaskGIT. (modified from [Halton-MaskGIT](https://github.com/valeoai/Halton-MaskGIT))
  
  - **`VAR/`** 
    Official implementation of the VAR model (modified from [FoundationVision/VAR](https://github.com/FoundationVision/VAR)).

---

### ⚙️ Training Configurations

You can find the training configuration files in the following directories:

- **CIFAR-10 Tokenizer** 
  `./cifar10_exp/VQ_Selection_Real_Data/configs_codes_fixed_ratio`

- **Generative Model Tokenizers** 
  `./generative_model_exp/Tokenizer/ImageFolder/configs`

- **MaskGIT** 
  `./generative_model_exp/MaskGIT/scripts`

- **VAR** 
  `./generative_model_exp/VAR/scripts`

---

### 🙏 Acknowledgments

We gratefully acknowledge the following open-source repositories:

- **CIFAR-10 Experiments** 
  Based on [vqvae](https://github.com/MishaLaskin/vqvae).

- **Tokenizer Training** 
  Based on [XQGAN](https://github.com/lxa9867/ImageFolder).

- **MaskGIT** 
  Based on PyTorch implementation of [Halton-MaskGIT](https://github.com/valeoai/Halton-MaskGIT).

- **VAR** 
  Based on the official implementation from [FoundationVision/VAR](https://github.com/FoundationVision/VAR).
