This is the official implementation of the paper "Scalable Decision Focused Learning via Online Trainable Surrogates".

# Instructions

## Build datasets

To build a dataset, execute the corresponding "generate" python file, passing the required parameters.

### Knapsack

Run the 'generate_kp_data.py' file.

#### Parameters:

- **mode** -> Generation mode: choose between "kp values", "kp weights" or "kp capacity"
- **name** -> Dataset name
- **input_dim** -> Input dimension
- **output_dim** -> Output dimension
- **num_instances** -> Number of instances to generate
- [OPTIONAL] **--seed** -> Random seed [default=24]
- [OPTIONAL] **--deg** -> Polynomial degree correlation [default=5]
- [OPTIONAL] **--mul** -> Multiplicative noise [default=0.1]
- [OPTIONAL] **--add** -> Additive noise [default=0.03]
- [OPTIONAL] **--cap** -> Relative capacity [default=0.5]
- [OPTIONAL] **--corr** -> Correlate values and weights: choose between 0, 1 or 2 [default=1]
- [OPTIONAL] **--rho** -> rho term [default=0.0]
- [OPTIONAL] **--penalty** -> Penalty term [default=10.0]

#### Example:

```
python3 generate_kp_data.py "kp capacity" "kp_capacity_30_items" 4 30 1000  
```

### Weighted Set Multi-cover

Run the 'generate_wsmc_data.py' file.

#### Parameters:

- **name** -> Dataset name
- **input_dim** -> Input dimension
- **n_items** -> Output dimension (number of items)
- **n_sets** -> Number of sets
- **num_instances** -> Number of instances to generate
- [OPTIONAL] **--seed** -> Random seed [default=24]
- [OPTIONAL] **--density** -> Expected density in cover matrix [default=0.02]
- [OPTIONAL] **--deg** -> Polynomial degree correlation [default=5]
- [OPTIONAL] **--mul** -> Multiplicative noise [default=0.1]
- [OPTIONAL] **--add** -> Additive noise [default=0.03]
- [OPTIONAL] **--penalty** -> Penalty term [default=10.0]

#### Example:

```
python3 generate_wsmc_data.py "wsmc_10_50" 4 10 50 1000
```

### Toy


Run the 'generate_toy_data.py' file.

#### Parameters:

- **name** -> Dataset name
- **input_dim** -> Input dimension
- **output_dim** -> Output dimension
- **num_instances** -> Number of instances to generate
- [OPTIONAL] **--seed** -> Random seed [default=24]

#### Example:

```
python3 generate_toy_data.py "toy_64" 8 64 1000
```

## Run experiments

Build a training configuration using the json format (see *data/experiments/training configurations* for more details on the available setups).
Then run the 'train.py' file indicating the desired training configuration.

#### Example:

```
python3 train.py "wsmc_10_50_training_basic"
```

Results will be saved in *data/experiments/results*.
