import argparse
import os
import json

from src.generators.toy_generator import ToyGenerator

PATH = os.path.join("data", "toy")


def parse_arguments() -> argparse.Namespace:

    parser = argparse.ArgumentParser(description='Data generation')
    parser.add_argument('name', type=str, help='Dataset name')
    parser.add_argument('input_dim', type=int, help='Input dimension')
    parser.add_argument('output_dim', type=int, help='Output dimension')
    parser.add_argument('num_instances', type=int, help='Number of instances')
    parser.add_argument('--seed', type=int, help='Random seed', default=24)

    _args = parser.parse_args()

    return _args


def save_params(_args: argparse.Namespace, _path: str) -> None:

    params = {
        'name': _args.name,
        'input_dim': _args.input_dim,
        'output_dim': _args.output_dim,
        'num_instances': _args.num_instances,
        'seed': _args.seed,
    }

    save_path = os.path.join(_path, _args.name + "_config.json")

    with open(save_path, "w") as outfile:
        json.dump(params, outfile, indent=4)


if __name__ == '__main__':

    args = parse_arguments()

    name = args.name
    input_dim = args.input_dim
    output_dim = args.output_dim
    num_instances = args.num_instances
    seed = args.seed

    generator = ToyGenerator(name, input_dim, output_dim)
    generator.generate(PATH, num_instances, seed)

    save_params(args, PATH)
