from abc import ABC, abstractmethod

import numpy as np


class DatasetReader(ABC):

    def __init__(self, path: str):

        self._path = path

    @abstractmethod
    def read(self) -> tuple[np.ndarray, np.ndarray, np.ndarray, np.ndarray, dict]:
        pass

    def get_dims(self) -> tuple[int, int]:

        x, y, _, _, _ = self.read()

        return x.shape[1], y.shape[1]
