import json
import numpy as np
import pandas as pd

from src.readers.dataset_reader import DatasetReader
from src.utils.common import convert_to_numpy_nested_array
from src.utils.strings import *


class KnapsackCapacityReader(DatasetReader):

    def read(self) -> tuple[np.ndarray, np.ndarray, np.ndarray, np.ndarray, dict]:

        dataset_path = self._path + ".pkl"

        dataset = pd.read_pickle(dataset_path)

        x = convert_to_numpy_nested_array(dataset[INPUT])
        y = convert_to_numpy_nested_array(dataset[CAPACITY])
        z = convert_to_numpy_nested_array(dataset[SOLUTION])
        cost = np.array(dataset[COST])

        values = np.array(dataset[VALUES][0])
        weights = np.array(dataset[WEIGHTS][0])
        problem_params = {VALUES: values, WEIGHTS: weights}

        json_path = self._path + "_config.json"
        with open(json_path, 'r') as file:
            config = json.load(file)
            penalty = float(config[PENALTY])
            problem_params[PENALTY] = penalty

        return x, y, z, cost, problem_params
