import json
import numpy as np
import pandas as pd

from src.readers.dataset_reader import DatasetReader
from src.utils.common import convert_to_numpy_nested_array
from src.utils.strings import *


class KnapsackValuesReader(DatasetReader):

    def read(self) -> tuple[np.ndarray, np.ndarray, np.ndarray, np.ndarray, dict]:

        dataset_path = self._path + ".pkl"

        dataset = pd.read_pickle(dataset_path)

        x = convert_to_numpy_nested_array(dataset[INPUT])
        y = convert_to_numpy_nested_array(dataset[VALUES])
        z = convert_to_numpy_nested_array(dataset[SOLUTION])
        cost = np.array(dataset[COST])

        weights = np.array(dataset[WEIGHTS][0])
        capacity = float(dataset[CAPACITY][0])
        problem_params = {WEIGHTS: weights, CAPACITY: capacity}

        return x, y, z, cost, problem_params
