import json
import numpy as np
import pandas as pd

from src.readers.dataset_reader import DatasetReader
from src.utils.common import convert_to_numpy_nested_array
from src.utils.strings import *


class ProductionPlanningReader(DatasetReader):

    def read(self) -> tuple[np.ndarray, np.ndarray, np.ndarray, np.ndarray, dict]:

        dataset_path = self._path + ".pkl"
        u_path = self._path + "_underproduction_costs.npy"
        o_path = self._path + "_overproduction_costs.npy"
        json_path = self._path + "_config.json"

        dataset = pd.read_pickle(dataset_path)
        underproduction_costs = np.load(u_path)
        overproduction_costs = np.load(o_path)
        with open(json_path, 'r') as file:
            capacity = json.load(file)[CAPACITY]

        x = convert_to_numpy_nested_array(dataset[INPUT])
        y = convert_to_numpy_nested_array(dataset[DEMANDS])
        z = convert_to_numpy_nested_array(dataset[SOLUTION])
        cost = np.array(dataset[COST])

        problem_params = {
            UNDERPRODUCTION_COSTS: underproduction_costs,
            OVERPRODUCTION_COSTS: overproduction_costs,
            CAPACITY: capacity
        }

        return x, y, z, cost, problem_params
