import numpy as np
import pandas as pd

from src.readers.dataset_reader import DatasetReader
from src.utils.common import convert_to_numpy_nested_array


class ToyReader(DatasetReader):

    def read(self) -> tuple[np.ndarray, np.ndarray, np.ndarray, np.ndarray, dict]:

        dataset_path = self._path + ".pkl"
        weights_path = self._path + "_weights.npy"

        dataset = pd.read_pickle(dataset_path)

        x = convert_to_numpy_nested_array(dataset["x"])
        y = convert_to_numpy_nested_array(dataset["y"])
        z = convert_to_numpy_nested_array(dataset["z"])
        cost = np.array(dataset["cost"])

        weights = np.load(weights_path)
        problem_params = {"weights": weights}

        return x, y, z, cost, problem_params
