import numpy as np
import pandas as pd

from src.readers.dataset_reader import DatasetReader
from src.utils.common import convert_to_numpy_nested_array
from src.utils.strings import *


class WeightedSetMultiCoverReader(DatasetReader):

    def read(self) -> tuple[np.ndarray, np.ndarray, np.ndarray, np.ndarray, dict]:

        dataset_path = self._path + ".pkl"
        cover_matrix_path = self._path + "_cover_matrix.npy"

        dataset = pd.read_pickle(dataset_path)

        x = convert_to_numpy_nested_array(dataset[INPUT])
        y = convert_to_numpy_nested_array(dataset[DEMANDS])
        z = convert_to_numpy_nested_array(dataset[SOLUTION])
        cost = np.array(dataset[COST])

        sets_costs = dataset[SETS_COSTS][0]
        items_costs = dataset[ITEMS_COSTS][0]
        cover_matrix = np.load(cover_matrix_path)

        problem_params = {COVER_MATRIX: cover_matrix, SETS_COSTS: sets_costs, ITEMS_COSTS: items_costs}

        return x, y, z, cost, problem_params
