from time import time
import numpy as np

from src.solvers.solver import Solver
from src.utils.strings import *


class ToySolver(Solver):

    def __init__(self, height: float = 5.0, length: float = 1.0):

        super().__init__(minimization=True, positive_y=False)

        self._height = height
        self._length = length

    def _solve_method(self, x: np.ndarray, y: np.ndarray, params: dict[str, np.ndarray]) -> tuple[np.ndarray, float]:

        start_time = time()

        x = np.expand_dims(x, axis=1)
        weights = params["weights"]

        real_y = weights @ x
        real_y = real_y[:, 0]

        steps = float(np.linalg.norm(real_y - y, ord=2)) // self._length
        z = self._height * steps
        solution = np.array([z])

        runtime = time() - start_time

        return solution, runtime

    def compute_metrics(self, y: np.ndarray, solution: np.ndarray, params: dict[str, np.ndarray]) -> dict:

        metrics = dict()

        z = float(solution[0])

        metrics[TOTAL_COST] = z
        metrics[SUBOPTIMALITY_COST] = z
        metrics[PENALTY_COST] = 0.0
        metrics[FEASIBLE] = True

        return metrics
