import numpy as np
from collections.abc import Iterable


def shuffle_arrays(arrays: tuple) -> tuple:

    length = len(arrays[0])

    for array in arrays:
        assert len(array) == length

    p = np.random.permutation(length)

    shuffled_arrays = tuple([array[p] for array in arrays])

    return shuffled_arrays


def convert_to_numpy_nested_array(x: Iterable[Iterable]):

    array = [np.array(xi) for xi in x]

    return np.array(array)
