import numpy as np
import torch
import random


def set_seed(seed: int) -> None:

    random.seed(seed)
    np.random.seed(seed)
    torch.random.manual_seed(seed)


def bernoulli(prob: float) -> int:

    random_value = random.random()

    if random_value <= prob:
        return 1

    else:
        return 0


def estimate_kernel(distributions: list[torch.distributions.Distribution], x: torch.Tensor,
                    reduce_mean: bool = True) -> torch.Tensor:

    kernels = torch.cat([torch.exp(distribution.log_prob(x)) for distribution in distributions])

    if reduce_mean:
        kernel = torch.mean(kernels, dim=0)
    else:
        kernel = kernels

    return kernel
