from src.tasks.modular_addition import FewShotModularAddition
from src.tasks.modular_addition import ShuffledModularAddition
from src.tasks.modular_addition import ChainedModularAddition
from src.tasks.group_addition import CyclicGroupAddition
from src.tasks.group_addition import RosetteGroupAddition
from src.tasks.group_addition import DihedralGroupAddition
from src.tasks.multi_group_addition import MultiCyclicGroupAddition
from src.tasks.multi_group_addition import MultiRosetteGroupAddition
from src.tasks.multi_group_addition import MultiDihedralGroupAddition
from src.tasks.mix_group_addition import MixCyclicGroupAddition
from src.tasks.mix_group_addition import MixRosetteGroupAddition
from src.tasks.mix_group_addition import MixDihedralGroupAddition
from src.tasks.mix_group_addition import MixMonoidAddition
from src.tasks.navigation import RoomNavigation
from src.tasks.token_mix_group_addition import TokenMixCyclicGroupAddition
from src.tasks.token_mix_group_addition import TokenMixDihedralGroupAddition
from src.tasks.token_mix_group_addition import TokenMixRosetteGroupAddition

TASK_MAP = {
    "few-shot": FewShotModularAddition,
    "shuffled": ShuffledModularAddition,
    "chained": ChainedModularAddition,
    "cyclic": CyclicGroupAddition,
    "dihedral": DihedralGroupAddition,
    "rosette": RosetteGroupAddition,
    "multicyclic": MultiCyclicGroupAddition,
    "multidihedral": MultiDihedralGroupAddition,
    "multirosette": MultiRosetteGroupAddition,
    "mixcyclic": MixCyclicGroupAddition,
    "mixdihedral": MixDihedralGroupAddition,
    "mixrosette": MixRosetteGroupAddition,
    "mixmonoid": MixMonoidAddition,
    "navigation": RoomNavigation,
    "tokenmixcyclic": TokenMixCyclicGroupAddition,
    "tokenmixdihedral": TokenMixDihedralGroupAddition,
    "tokenmixrosette": TokenMixRosetteGroupAddition
}
