# Subjectivity ICL (subj.py) — Quick README

This README shows how to set up the environment, prepare data, and run the **grid-search** recipes for **PIAST** and **PIAST (E)** on `subj.py`.

---

## 1) Prerequisites

- Linux or macOS
- Python 3.9–3.11
- NVIDIA GPU with CUDA for vLLM
- Enough GPU memory for your chosen model (default examples assume Qwen2.5-7B-Instruct)

---

## 2) Run code

# PIAST
```
python subj.py --run-grid-search --grid-k 16 --grid-infer-sizes 70 --grid-craft-iters 15 --grid-refine-cands 10 --grid-replay-add 5 --shapley-permutations 3 --eval-on-test --use-vllm-for-evaluator --grid-seed 1,2,3
```
# PIAST (E)
```
python subj.py --run-grid-search --grid-k 16 --grid-infer-sizes 70 --grid-craft-iters 150 --grid-refine-cands 10 --grid-replay-add 5 --shapley-permutations 3 --eval-on-test --use-vllm-for-evaluator --grid-seed 1,2,3
```