We provide guidance for preparing the data used by MIPT. Note that not all data are needed for a specific experiments. Please check the `` Required Data`` fields in [README](README.md) to download necessary data. All data should by placed under the ``DATASET`` folder.

The data should be organized in the following format:
```
DATASET/
    coco/
        annotations/
            lvis_od_train.json
            lvis_od_val.json
            lvis_v1_minival_inserted_image_name.json
            lvis_v1_val.json
            lvis_v1_train.json
        train2017/
        val2017/
        test2017/
    Objects365/
        images/
        zhiyuan_objv2_train.json
    odinw/
       AerialMaritimeDrone/
       ...
       WildfireSmoke/
```



#### ``Objects365``
We found that the Objects365 v1 is unavailable now. Please try to download v2 as follows.

Download the [Objects365](https://www.objects365.org/overview.html) dataset from [YOLOv5](https://github.com/ultralytics/yolov5/blob/master/data/Objects365.yaml). 

You can also use custom datasets for modulated pre-training as long as they are in COCO format.

TODO: more detailed instruction


#### ``LVIS``
LVIS use the same images as COCO. Thus prepare the COCO images first.

    DATASET/coco

Download the following annotation files:
```
    wget https://penzhanwu2bbs.blob.core.windows.net/data/GLIPv1_Open/coco/annotations/lvis_v1_minival_inserted_image_name.json -O DATASET/coco/annotations/lvis_v1_minival_inserted_image_name.json

    wget https://penzhanwu2bbs.blob.core.windows.net/data/GLIPv1_Open/coco/annotations/lvis_od_val.json -O coco/annotations/lvis_od_val.json"
```
Also download the training set for extracting vision queries:
 ```   
    wget https://s3-us-west-2.amazonaws.com/dl.fbaipublicfiles.com/LVIS/lvis_v1_train.json.zip -O coco/annotations/lvis_v1_train.json.zip
```
Unpack the .zip file to ``coco/annotations/lvis_v1_train.json``, and convert it to coco format:
```
python utils/add_file_name.py
```



#### ``Object Detection in the Wild (ODinW)``

**Download ODinW**
```
python odinw/download_datasets.py
```

``configs/odinw_35`` contain all the meta information of the datasets. ``configs/odinw_13`` are the datasets used by GLIP. Each dataset follows the coco detection format.

Please refer to [GLIP](https://github.com/microsoft/GLIP/tree/main) for more details.