# 1. Set the variable once
config_name="linear_224_fix4_unified_simple_stage1"

# 2. Use it in your accelerate command and the log filename
# nohup bash -c '
#   CUDA_LAUNCH_BLOCKING=1 NCCL_DEBUG=TRACE \
#   TORCH_DISTRIBUTED_DEBUG=DETAIL HYDRA_FULL_ERROR=1 \
#   accelerate launch --multi_gpu --main_process_port=29506 \
#     src/train.py --config-name '"${config_name}"' 2>&1
# ' | tee -a "${config_name}.log" &

bash -c 'CUDA_VISIBLE_DEVICES=0 CUDA_LAUNCH_BLOCKING=1 NCCL_DEBUG=TRACE \
    TORCH_DISTRIBUTED_DEBUG=DETAIL HYDRA_FULL_ERROR=1 \
    accelerate launch --multi_gpu --main_process_port=29505 src/train.py --config-name '"${config_name}"''