# 常见问题整理

下面是swift使用过程中遇到的一些常见问题。

## 训练

### Q1: Swift微调支持的模型和数据集有哪些？
详见文档[支持的模型和数据集](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E6%94%AF%E6%8C%81%E7%9A%84%E6%A8%A1%E5%9E%8B%E5%92%8C%E6%95%B0%E6%8D%AE%E9%9B%86.html)。

### Q2: 使用自定义数据集训练时支持的数据格式有哪些？
自定义数据集格式见文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/%E8%87%AA%E5%AE%9A%E4%B9%89%E6%95%B0%E6%8D%AE%E9%9B%86.html)。

### Q3: 自定义数据集dataset_info.json格式，如何通过这种方式使用自定义数据集？
dataset_info.json格式见文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/%E8%87%AA%E5%AE%9A%E4%B9%89%E6%95%B0%E6%8D%AE%E9%9B%86.html)。命令行，`--custom_dataset_info xxx.json`，`--dataset <dataset_id_or_path>`。

### Q4: 如何在界面训练使用自定义数据集？
界面训练使用自定义数据集与命令行一致，参考文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/%E8%87%AA%E5%AE%9A%E4%B9%89%E6%95%B0%E6%8D%AE%E9%9B%86.html)。

### Q5: 数据集jsonl文件里的一行能不能写成这样？{"index": "00000", "query": "11111", "response": "22222", 'source':'qqq'}
可以有额外字段的，这些字段不会被使用。

### Q6: 命令行参数在哪个文档中查看？
详见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q7: 离线环境训练需要配置的参数有哪些？
`--model 本地路径`，`--check_model false`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q8: model_type在哪儿查看？
查看文档[支持的模型和数据集](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E6%94%AF%E6%8C%81%E7%9A%84%E6%A8%A1%E5%9E%8B%E5%92%8C%E6%95%B0%E6%8D%AE%E9%9B%86.html)。

### Q9: 模型训练完能直接转gguf格式吗？
目前只支持导出ModelFile，详见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q10: swift支持预训练吗，我看只有sft？
支持，命令行`swift pt`，[预训练例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/pretrain)，数据集格式见[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/%E8%87%AA%E5%AE%9A%E4%B9%89%E6%95%B0%E6%8D%AE%E9%9B%86.html)。

### Q11: 想问一下用lora微调的模型，如果想断点续训的话，是应该先把它合成一整个模型吗，还是可以不合起来，直接通过路径来指定原模型和lora块
不合并，`--resume_from_checkpoint output/xxx/vx-xxx/checkpoint-xxx`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q12: 我想控制一下从网上下载下来的原始模型权重的位置，怎么才能做到把原始的模型放在指定的文件夹里呢？
可以配置环境变量`MODELSCOPE_CACHE=your_path`将原始的模型存到指定路径；如果用sdk下载，通过`cache_dir="本地地址"`；也可以使用`modelscope download`命令行工具或`git`下载，详见modelscope文档[模型下载](https://modelscope.cn/docs/models/download)。训练时`--model`配置本地路径即可。如果需要在离线环境训练，配置`--check_model false`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q13: 有人在用ms-swift遇到过这个问题？
```text
[rank6]: pydantic_core._pydantic_core.ValidationError: 1 validation error for DeepSpeedZeroConfig
[rank6]: stage3_prefetch_bucket_size
[rank6]: Input should be a valid integer, got a number with a fractional part [type=int_from_float,input_value=11560550.4，in put_type=float]
[rank6]: For further information visit https://errors.pydantic.dev/2.8/v/int_fro_float
```
`deepspeed`版本降到`0.14.*`。

### Q14: 有微调qwen-2-vl的完整的教程和命令行吗？
参考多模态模型训练的[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/multimodal)。

### Q15: 多模态大模型微调有什么支持的trick吗，类似llm的neftune?
`piassa/olora/dora`这些`lora`的变种或者`fourierft`都可以尝试。参考`sft`参数里面的各种trick，有一些不一定在多模态上适用。

### Q16: 训练过程中eval得到的acc和对应保存的ckpt去重新推理一遍计算得到的acc不是一致的
训练时候的eval_acc和推理时候的acc 计算方式不一样的。`acc_strategy`: 默认为`'token'`, 可选择的值包括: `'token'`, `'seq'`.

### Q17: 魔搭官方镜像与swift环境
`docker run`命令启动容器即可，如：`docker run --gpus all -p 8000:8000 -it -d --name ms modelscope-registry.cn-beijing.cr.aliyuncs.com/modelscope-repo/modelscope:ubuntu22.04-cuda12.4.0-py311-torch2.6.0-1.26.0-LLM /bin/bash`，启动容器后拉最新代码安装swift。另外，针对大模型训练场景，提供了`ms-swift`镜像，额外增加了`Megatron-SWIFT`的依赖，如：`modelscope-registry.cn-beijing.cr.aliyuncs.com/modelscope-repo/modelscope:ubuntu22.04-cuda12.4.0-py311-torch2.6.0-vllm0.8.5.post1-modelscope1.26.0-swift3.4.1.post1`，详见[swift安装文档](https://swift.readthedocs.io/zh-cn/latest/GetStarted/SWIFT%E5%AE%89%E8%A3%85.html)。

### Q18: 多机多卡训练命令行
详见[多机多卡例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/multi-node)

### Q19: 如何选择template?
见[issue](https://github.com/modelscope/ms-swift/issues/1813)。

### Q20: 多卡训练torchrun和swift sft如何使用？
`swift sft`走的就是`torchrun`。

### Q21: 有个问题，因为我的sft数据集太大了，然后每次tokenize都需要很久，有解决方案吗？
使用`lazy_tokenize`或流式读取`streaming`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q22: 训练时，如果两个数据集直接追加一起放在训练集中，模型在训练的时候内部会有shuffle的流程吗？还是按顺序取数据去训练？
命令行参数`dataset_shuffle`，详见[命令行参数文档](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q23: 如果模型两张卡，数据不开并行，deepspeed就会出现报错，怎么处理呢？
`deepspeed` 和 `device_map`是不兼容的，两个只能选1个。

### Q24: 在线训练时已经下载的数据集，离线重新训练为什么还要下载？
数据文件中有url，不支持离线训练。

### Q25: vlm模型训练如何减少显存使用？
配置`--freeze_vit true`，以及限制最大像素的参数`--max_pixels`。

### Q26: 为什么WEB-UI界面上支持的模型比文档中少？
升级一下ms-swift。

### Q27: 没有适配model_type的模型，sft时可以自定义special_tokens和chat_template吗？
可以。参考接入模型的PR以及自定义模型数据集文档。

### Q28: 可以在python脚本里面用DPO去训练qwen2-vl吗？
可以。从`swift.llm`中导入`rlhf_main` 和`RLHFArguments`。

### Q29: 请问训练MLLM时，可否先进行纯文本的预训练，然后接入VQA数据集进行微调呢？
可以。也可以混着训练。

### Q30: 基于qwen2的sft模型进行dpo训练，v100的机器，训练时都是Nan呢？
V100机器要用fp32训练qwen2。

### Q31: 想问一下，swift，能支持蒸馏吗？
参考这个[例子](https://github.com/modelscope/ms-swift/blob/main/examples/sampler/distill/distill.sh)。

### Q32: 当前训练完默认最多保存两个checkpoint，如果想多保存几个应该怎么修改呢？
`--save_total_limit`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q33: Grounding任务中通用数据格式支持一个类别有多个实例吗？
目前均支持了一个物体对应多个bbox，参考文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/%E8%87%AA%E5%AE%9A%E4%B9%89%E6%95%B0%E6%8D%AE%E9%9B%86.html#grounding)。

### Q34: 这个错误为什么会出现在这，numpy.object找不到在哪？
`numpy==1.26.3`，尝试一下。

### Q35: swift框架能支持序列并行了吗？
支持。参考这里的[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/long_text)。

### Q36: 用v100微调qwen2-1.5B时，loss': 0.0, 'acc': 0.0, 'grad_norm': nan，是什么问题呢?
尝试用fp32。

### Q37: gptq量化模型，能全参数微调吗？
不能。gptq模型的int型参数无法参与求导，只能附着lora等额外结构参与更新。

### Q38: 请问如果想用qlora的方式微调的话应该如何设置参数呢?glm4-chat
参考qlora[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/qlora)。

### Q39: 请教一个问题，我应该如何在swift框架下扩充我的词表呢？
swift目前还不支持词表扩充。

### Q40: 同名的模型是可以直接使用huggingface上的吗？
设置环境变量`USE_HF=1`。

### Q41: 请问Qwen2-VL-2B能进行增量预训练吗？有指导文件吗?有图文,也有纯文本的。
支持了，如果继续预训练将所有的内容放在response中就可以了。

### Q42: 请问下用视频做训练的时候，如何在参数中控制抽帧率，设了frame_rate设不起, minicpmv
设置环境变量`MAX_NUM_FRAMES`。

### Q43: swift在训练的时候，可以把验证集的推理结果保存下来吗？
训练结束后，运行swift infer，会保存。

### Q44: 我全量full参数dpo，为何保存的checkpoint 比原本模型文件要大呢?整整大了1倍
用V100微调，存的是fp32类型。

### Q45: 多机训练速度缓慢，在使用swift框架进行LLM训练时，发现采用deepspeed zero3训练会出现严重的速度下降问题
详见[issue](https://github.com/modelscope/ms-swift/issues/1825)。

### Q46: swift现在是支持qwen2-vl多阶段预训练的吗？我看官方的最佳实践里的sft好像都是vit+llm一起训的，不知道支不支持单独finetune
`--freeze_vit`，`--freeze_aligner`，`--freeze_llm`这几个参数可以控制，详见[命令行参数文档](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html#tuner)。

### Q47: qwen2-vl是不是不支持混合纯文本数据?
支持图文和纯文本。

### Q48: 微调的时候可以绘制不同数据集的loss曲线吗？
支持channel loss，参考这个[例子](https://github.com/modelscope/ms-swift/blob/main/examples/train/plugins/channel_loss.sh)

### Q49: 模型训练后，回复重复了很多内容
参考[预训练与微调](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E9%A2%84%E8%AE%AD%E7%BB%83%E4%B8%8E%E5%BE%AE%E8%B0%83.html)。如果训练过程中出现重复的情况，请多训练几个epoch, 清洗数据, 全参数训练, 采用RLHF的方式缓解。

### Q50: 想问一下swift目前支持prompt tuning或者prefix tuning吗？
不支持，这两个方法知识遗忘比较严重，目前不推荐使用。

### Q51: 两张A10训练报错如下：
```text
[rank0]: torch.distributed.DistBackendError: NCCL error in:../torch/csrc/distributed/c10d/ProcessGroupNCCL.cpp:1970， unhandled system error (run with NCCL_DEBUG=INFO for details),NCCL version 2.20.5
[rank0]:ncclSystemError: System call (e.g. socket,malloc) or external library call failed or device error.
```
请检查共享内存是否太小，nccl需要共享内存。

### Q52: 请问在采用DDP微调训练的过程中，冻结某些层时导致的某些参数未参与梯度回传问题怎么解决？
配置参数`--ddp_find_unused_parameters true`。

### Q53: swift有没有数据集质检工具？
[data-juicer](https://github.com/modelscope/data-juicer)。

### Q54: web端在哪启动模型并行?只找到了数据并行的勾选项，没找到模型并行在哪。
指定可见显卡就可以。

### Q55: 设置--dataset的话，怎么让数据集下载到固定位置，我在命令行参数没找到，下次如果再次读取的话如何可以从下载的地方读取
`dataset_path`支持文件夹，一般是`git clone`下载下来的数据集文件夹。详见[自定义数据集文档](https://swift.readthedocs.io/zh-cn/latest/Customization/%E8%87%AA%E5%AE%9A%E4%B9%89%E6%95%B0%E6%8D%AE%E9%9B%86.html#dataset-info-json)。

### Q56: --streaming true，我设置num_train_epochs会报错让我设置max_steps。不可以只设置num_train_epochs吗？
详见`streaming`参数说明，[命令行参数文档](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html#id4)。

### Q57: 好奇tools为啥是"[]"，不是直接支持[]呢，能否帮忙解答一下，这个tools为啥是"[]"这种格式呢，不是直接使用[]呢，有些不理解
这是因为datasets的底层pyarrow对于类型管控比较严格。我们官方的grounding数据集的objects部分也是因为这个原因要用str，要不pyarrow就会报错：你每行的类型不一致。

### Q58: 这个参数不能用吗？check_dataset_strategy==discard
swift3.0没这个参数了，用`strict`参数。

### Q59: 运行sft命令出现报错如下：
```text
RuntimeError: Expected to mark a variable ready only once.This error is caused by one of the following reasons: 1) Use of a module parameter outsid forward function. Please make sure model parameters are not shared across multiple concurrent forward-backward passes. or try to use _set_static_graph( ) as round if this module graph does not change during training loop.2) Reused parameters in multiple reentrant backward passes. For example, if you use multiple oint` functions to wrap the same part of your model, it would result in the same set of parameters been used by different reentrant backward passes multiple and hence marking a variable ready multiple times. DDP does not support such use cases in default. You can try to use _set_static_graph( ) as a workaround if dule graph does not change over iterations.
```
加一下这个参数，`--gradient_checkpointing_kwargs '{"use_reentrant": false}'`。

### Q60: 有遇到过这个问题嘛？AttributeError:’TrainerState’ object has no attribute ’last_model_checkpoint’
数据集太少了，增加一些。数据数量不足一个step导致的报错。

### Q61: 我看到custompreprocessor里面可以定义preprocess，这个是在训练开始前全部会处理好，还是一边训练一边加载的啊
如果设置了参数`--streaming true`，就是一边训练一边加载。默认是全部处理完然后训练。

### Q62: 全参数训练internvl2_5，为啥里面的 freeze parameters默认就有vision_model 和 mlp1？我看命令行参数的文档里面freeze parameters默认为[],命令中显示设置 freeze vit， freeze aligner， freeze llm都为False，又会打印出来trainable parameters：[‘mlp1’] 也不知道是指只有mlp1可以train 还是 所有的paras都可以train 只是mlp1打印一下
先freeze parameters再active parameters。`freeze vit/freeze aligner/freeze llm`这三个参数会对freeze parameters 和trainable parameters进行调整.因为有些模型的`vit`中包含`aligner`，所以会将`aligner`单独加入trainable_parameters。

### Q63: 请问swift中的llamapro对多模态做适配了吗？
支持的。

### Q64: 我发现2.x支持MAX_PIXELS，3.x文档里有个--max_pixel参数是一个意思吗，他的处理逻辑是啥样的？我用12000*9000的图片，2.x设置resacle_image训练internvl还是会崩
环境变量的参数是对应模型的参数，`MAX_PIXELS`只支持qwen2vl的，internvl有自己的环境变量参数，详见[特定模型参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html#id18)。

### Q65: 从qwen base模型微调成chat模型有没有实践文档，有什么要特别配置的吗?
A: `swift sft`，没有其他需要特别配置的，参考[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/base_to_chat)。

### Q66: sequence parallel例子在哪呀？
A: 看这个例子[sequence_parallel](https://github.com/modelscope/ms-swift/tree/main/examples/train/long_text)。

### Q67: swift能支持训练自己定义的模型结构吗？
可以的，只需要自定义`get_model_tokenizer_xxx`函数就好了，返回`model`和`tokenizer`。

### Q68: 我用"name_or_path": "/mnt/workspace/model/Qwen2.5-14B-Instruct"跑longlora 发现出现了报错，不会是只有个llama系列可以使用longlora吧
只有llama系列能用`longlora`。

### Q69: 想问下swift怎么加入自己的special token？
在`get_model_tokenizer`函数中增加。

### Q70: --freeze_parameters_ratio这个参数，如果设定为0.7，是不是说明训练的时候只更新llm的30%的参数？是随机更新30%吗，这个参数更新的机制是什么呀？
从下往上freeze。

### Q71: map过程为啥这么慢，这是正常的吗？
```text
Map: 4%|██ | 9000/203823 [02:18<50:34, 64.19 examples/s]
```
设置参数`--dataset_num_proc`可以开多进程。

### Q72: 请问数据集如何能够删除重新下载，感觉数据集出了点问题
设置参数`--download_mode`。

### Q73: 请问这个问题如何解决？safetensors_rust.SafetensorError: Error while deserializing header: HeaderTooLarge
磁盘空间不足了，模型没有保存完整。

### Q74: swift3.0不支持get_default_template_type是吗？
请查看`model.model_meta.template`，信息都存在`model.model_meta和model.model_info`。

### Q75: 魔搭swift微调支持herms格式的agent微调嘛，我看qwen2.5使用vllm原生支持hermes格式的工具调用，怎么swift上没有看到相关的
目前没有支持`hermes`格式，主要还是`toolbench`和`react`两个格式,因为`react`应用比较广泛一些，目前swift的deploy也支持解析这两种格式并给出`openai tool calling`的。

### Q76: 请问默认模型训练都是left padding是吧?
训练可以选择使用左padding还是右padding。默认是右padding, `batch infer`都是左padding。

### Q77: 请问下现在支持grounding任务了吗
examples下有[例子](https://github.com/modelscope/ms-swift/blob/main/examples/train/multimodal/grounding.sh)。

### Q78: 请问现在ms-swift支持对比学习，从而训练llm_emb吗?
支持，[例子](https://github.com/modelscope/ms-swift/blob/main/examples/train/embedding)。

### Q79: 话说直接从peft和trl库，手搓微调和grpo代码和swift官方在同参数下进行训练，效果差异大吗？
区别不大，额外支持了多模态。

### Q80: swift 目前不支持 minicpmo2_6 使用音频模态输入的训练吗？会报错： assert media_type in {'image', 'video'}
目前不支持音频。

### Q81: swift可以微调deepseek R1 671B吗？
可以，template是接入了的，不过过程会比较麻烦，要先fp8转bf16。

### Q82: 最新的swift框架不是通过这个命令来指定模型的位置的么？这是我已经下载好的模型位置，不知道为什么还要下载，还下不下来，提示报错git clone
```shell
--model /mnt/workspace/.cache/modelscope/hub/deepseek-ai/deepseek-vl2/ \
```
有些需要clone repo，然后通过`local_repo_path`指定。

### Q83: swift现在支持多模态的grpo吗？
支持。

### Q84: grpo的reward函数支持自己定义么?
支持，参考[examples/train/grpo/plugin](https://github.com/modelscope/ms-swift/tree/main/examples/train/grpo/plugin)。

### Q85: 请问为什么 --torch_dtype float16 （卡不能使用bf16）会出现报错：lib/python3.12/site-packages/torch/amp/grad_scaler.py", line 260, in _unscale_grads_ raise ValueError("Attempting to unscale FP16 gradients.") ValueError: Attempting to unscale FP16 gradients.
全参数，不能fp16训练的。

### Q86: 请教一个问题。我用swift训练了一个reward模型（基线是qwen2.5-7b），然后用在ppo或者grpo中加载会报错。reward模型是lora训练的。
```shell
--rlhf_type ppo \
--model Qwen/Qwen2.5-14B-Instruct \
--reward_model /mnt/workspace/output/rm/model --train_type lora \
--dataset 'AI-ModelScope/alpaca-gpt4-data-zh#20000' --torch_dtype float32 --num_train_epochs 1 \
--per_device_train_batch_size 1 --per_device_eval_batch_size 1 --learning_rate 1e-5 --lora_rank 8 --lora_alpha 32 \
--target_modules all-linear \
--gradient_accumulation_steps 16 --eval_steps 100 --save_steps 100 \
```
lora训练的reward model需要merge一下。

### Q87: 各位大佬，请问要微调deepseek_vl2，transformers用什么什么版本？官方文档说<4.42，但是4.42及以下也报错。peft版本也要降低吗？
`peft==0.11.*`。

### Q88: 请问generate train split太慢了有没有什么好办法呀（大概有30多个数据集，总数据量百万左右）。之前swift 2.x好像没有这么慢。lazy tokenize 已经开了
设置`--dataset_num_proc 16`。

### Q89: 请问下微调qwen2.5vl的时候，我想使用全参数微调visual encoder同时使用LoRA微调LLM，怎么实现呢？
参考这里[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/multimodal/lora_llm_full_vit)。
 
### Q90: 问一下，swift怎么使用自定义的损失函数？
plugin中加就可以了。

### Q91: 请问下MoE的参数有哪些，参数表里关键字搜索不到？专家数量，专家路由这些参数怎么设置？
直接用config.json中的参数。

### Q92: grpo训练中使用lmdeploy会报相关函数不存在的问题，想请教下具体问题，在lmdeployengine类里面确实没找到load_weights这个函数
只在turbomind引擎下支持。

### Q93: Moonlight-16B-A3B-Instruct, 我在微调这个模型的时候报错怎么办?ms-swift好像不支持这个模型进行微调
因为是模型文件中禁止了训练, 参考deepseek_vl2的解决方案，你搜搜issue。

### Q94: 训练时出了这个错应该咋解决？RuntimeError: “triu_tril_cuda_template“ not implemented for ‘BFloat16'
```shell
CUDA_VISIBLE_DEVICES=01,2,3,4,5,6,7 \
swift sft \
    --model Internlm3-8b \
    --dataset train.json \
    --train_type full \
    --torch_dtype bfloat16 \
    --num_train_epochs 5 \
    --per_device_train_batch_size 1 \
    --deepspeed zero3 \
    --per_device_eval_batch_size 1 \
    --learning_rate 1e-4 \
    --gradient_accumulation_steps 16 \
    --eval_steps 100 \
    --save_steps 100 \
    --save_total_limit 5 \
    --logging_steps 5 \
    --max_length 2048 \
    --output_dir output \
    --warmup_ratio 0.05 \
    --dataloader_num_workers 4
```
升级torch。

### Q95: grpo训练，loss和grad_norm全是0，正常的吗？
```text
{'loss':    0.0.    'grad norm':0.0,    'learning_rate':9e-08,    'memory(GiB)':88.1，    'train_speed(iter/s)':0.009252，    'completion_length':    150.00000763，    'response_clip ratio': 0.0,    'rewards/Format':1.0,    'reward
: 1.0,    'reward std':0.0，    'kl': 0.0, 'clip_ratio': 0.0,    'epoch': 0.0， 'qlobal step/max steps':'1/1052'，    'percentage':'0.10%    'elapsed time':    '36s    'remaining time': '10h 43m 54s'}
{'loss': 0.0，'grad_norm':0.0，'learning_rate': 1.8e-07,'memory(GiB)':94.15，'train_speed(iter/s)':0.014782，'completion_length': 133.25000763，'response_clip_ratio': 0.0，'rewards/Format': 1.0, 'rewa rd': 1.0，'reward_std': 0.0, 'kl': 0.0，'clip_ratio': 0.0,'epoch': 0.0, 'global_step/max_steps': '2/1052'，'percentage': '0.19%', 'elapsed_time': '1m 3s'， 'remaining_time': '9h 19m 49s'}
{'loss': 0.0， 'qrad norm': 0.0, 'learning rate': 2.7e-07,'memory(GiB)': 94.15，'train_speed(iter/s)': 0.018695，'completion_length': 123.08333969，，'response_clip_ratio': 0.0，'rewards/Format': 1.0, 'rewa rd': 1.0， 'reward_ std': 0.0,'kl': 0.0,'clip_ratio': 0.0， 'epoch': 0.0， 'global_step/max_steps': '3/1052'，'percentage': '0.29%，'elapsed_time': '1m 29s'，'remaining_time': '8h 39m 34s'}
```
训练过程中loss接近0是正常情况，参考[issue](https://github.com/huggingface/open-r1/issues/239#issuecomment-2646297851)。

### Q96: 请教一下这个grpo的内置奖励函数，从哪里可以传入accuracy_orm
目前是直接改代码。

### Q97: 我看这奖励函数有solution参数，是要从数据集里面传过来吗？就是我数据集必须有solution这项？
是的，针对math问题，不然不好算accuracy。

### Q98: 训练为什么没有token_acc？
有些模型`logits`和`labels`数量对不上，就不算的。

### Q99: 微调Ovis2 使用lora参数不起作用？加不加--train_type lora \，好像都是全参数微调？显存没变化。
`--max_length`限制一下，这个模型有点特殊，需要padding到max_length。

### Q100: 请问下用qwen2.5跑一个分类任务，抱下面的错误，是哪里配置的有问题呢？ValueError: The model did not return a loss from the inputs, only the following keys: logits. For reference, the inputs it received are input_ids,attention_mask.
数据集是这样的：{"messages": [{"role": "user", "content": "xxxxx"}, {"label": 1}]}
`label`写在`message`同级。

### Q101: 启动了VllmEngine，要如何退出呀？就是调用了engine，模型就被载入显存准备工作。但是我推理完想要engine释放显存。下次调用时，再加载。而不是一直占用
sleep mode啊，支持的。`engine.sleep(level=1)/engine.wake_up()`，构造的时候加一个`enable_sleep_mode=True`。

### Q102: 求问，streaming模式下，trainer_sampler_random是不是就没有作用了呢？
streaming是不随机的。

### Q103: 请问grpo使用vllm进行推理，vllm可以设置trust_rwmote_code吗？
默认就是true的。

### Q104: 请教一下，pretrain阶段数据集比较大，用了streaming流式和packing打包数据，这时候需要设置 max_steps，有没有参数或者命令可以根据epochs、bs等参数计算打包后的总的steps吗？
设置`--max_steps`或`--max_epochs`，详见[命令行参数文档](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html#id4)streaming参数说明。

### Q105: unsloth训练，报错：assert(type(target modules) in (list,tuple,))。配置的参数是--target modules all-linear
别用`all-linear`，改为具体的模块列表，比如`--target_modules q k v`。

### Q106: Swift现在支持多标签分类么？
支持的。自定义数据集文档有格式，然后在命令行参数文档中搜索一下`problem_type`，改一下，其他和回归是一样的。

### Q107: 请问packing中flash_attn是分开处理的还是合并处理的？
一定需要flash_attn，不然是有误差，attention_mask会出问题。

### Q108: 请问对于qwen2.5-omni来说--freeze_vit false意味这视觉编码器和音频编码器都打开了，有什么办法可以只打开音频编码器不打开视觉编码器吗？
`--target_regex`写一下。

### Q109: 请问现在swift的强化学习那几种训练方法支持序列并行么？
支持pt, sft, dpo and grpo。

### Q110: 使用 lora sft之后是不会储存tokenizer.json吗
lora不会存储，merge后才会把这些文件迁移过来，因为lora目录需要配合原模型使用。

### Q111: GRPO 的reward_model 和 reward_funcs可以一起用吗？
可以。

### Q112: 想请教一下，在进行GRPO时不打算引入KL项，有相关的参数可以调整吗？
命令行参数搜一下beta。

### Q113: 请教一个问题，做grpo的时候，如何在orm的自定义奖励函数中获取原始标签呢？我打印了kwargs的messages字段，里面的每一项的assistant的content的值已经被替换成生成的结果了
放到另外的列里。

### Q114: 默认只用 num_iterations=1 的话，clip 就失去作用了吧？dapo 的 clip higher 也没用。我看 veRL 有个 micro batch 可以设置单轮小批次更新 policy model 来使得 clip 项生效，ms-swift 的 mini batch 看源码貌似只是做了梯度累加？
是的，需要num_iterations>1。

### Q115: 请问qwen2.5-omni的训练支持全参训练吗，是否支持talker的训练？
目前不支持talker训练，只有thinker。

### Q116: 请问，sequence parallel是否可以和liger kernel同时启用呀？
可以。

### Q117: 请问ppo训练rm和policy有什么要求呢？
现在ppo还只支持rm和policy是同一系列的模型(tokenizer/template)。

### Q118: 还想问一下，由于llama3.1没有小于8B的模型，因此我想用3.2 1B的的来微调，那么还能用Llama-3.1这个奖励模型吗？
要求是`template`和`tokenizer`要一样， 3.1 和 3.2 应该问题不大。

### Q119: 请问swift是否能缓存一份mappiing之后的数据？方便排查训练数据的问题
设置`--load_from_cache_file false`。

### Q120: 全参数训练为啥会有warning: none of the inputs have requires_grad=True?
如果vit没有训练，那有这个warning是正常的，如果训练了，则不应该抛出。

### Q121: 现在qwen2.5vl ulysses支持sdpa吗？
vl模型的目前仅支持flash-attn，纯文本两种都支持。

### Q122: 请问这图片列表形式的videos现在支持了吗？格式如下
```json
{"messages": [{"role": "assistant", "content": "<video>是一只狮子在跑步"}], "videos": [["1.jpg","2.jpg"]]}
```
支持了，使用文件目录的方式。

### Q123: 请教一个问题，grpo脚本中的save_steps指的是step还是global step？目前本地训练显示的global step是18， wandb上显示的step是628。
`global_step`，本地tqdm显示的。

### Q124: use_logits_to_keep 现在多模态大模型上可以用吗？
如果多模态token的展开在模型的forward内会报错。

### Q125: 请问一下为什么训练到会有好几次显存大幅度增加，已经50step或者100step
设置环境变量`PYTORCH_CUDA_ALLOC_CONF`，具体查看torch文档。

### Q126: 请问packing_cache这个参数设置，多机训练，我设置了文件夹地址后还是会报错，这有啥特殊要求吗?
需要设置为共享的磁盘路径。

### Q127: Qwen3非thinking模式和thinking模式，数据集和参数设置有什么不同吗？
查看这个[issue](https://github.com/modelscope/ms-swift/issues/4030)。

## 推理

### Q1:swift推理有文档吗？
swift支持python脚本、命令行、ui界面推理，详见[推理和部署](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E6%8E%A8%E7%90%86%E5%92%8C%E9%83%A8%E7%BD%B2.html)。

### Q2: 训练后的模型如何使用数据集推理？
参数`--load_data_args true`或`--val_dataset <your-val-dataset>`，见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q3: swift推理的时候可以指定下载好的模型吗？
`--model`配置本地路径即可，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q4: 我想在一个没有label的数据集上推理，怎么做呢？我看文档里面的数据集格式都是训练集
配置参数`--val_dataset <your-val-dataset>`。

### Q5: 遇到报错ValueError: Input length of input_ids is 35, but `max_length` is set to 20.如何解决？
```text
raise ValueError(
ValueError: Input length of input_ids is 35, but `max_length` is set to 20. This can lead to unexpected behavior. You should consider increasing `max_length` or, better yet, setting `max_new_tokens`.
```
设置`model.generation_config.max_new_tokens`。

### Q6: qwen2-vl推理（训练）爆显存
设置命令行参数`--max_pixels xxx`、环境变量`MAX_PIXELS=xxx`、或特定模型参数`--model_kwargs '{"max_pixels": xxx}'`，其中环境变量仅对文档中对应的模型生效，详见文档[特定模型参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html#id18)。

### Q7: v100显卡，在python虚拟环境中，参考https://swift2x.readthedocs.io/zh-cn/latest/Multi-Modal/qwen2-vl%E6%9C%80%E4%BD%B3%E5%AE%9E%E8%B7%B5.html 完成环境准备，在测试推理命令：CUDA_VISIBLE_DEVICES=0,1,2,3 swift infer --model_type qwen2-vl-7b-instruct 时报错：RuntimeError: probability tensor contains either `inf`, `nan` or element < 0
尝试用A10或者3090机器推理。

### Q8: 运行下面命令，预测之后的结果在哪里？CUDA_VISIBLE_DEVICES=0 swift infer --ckpt_dir output/glm4v-9b-chat/vx-xxx/checkpoint-xxx-merged --load_data_args true
日志中会打印路径。

### Q9: 现在最新的swift版本，infer命令能通过logprobs参数输出概率值吗？
可以输出logprobs，命令行推理设置`--logprobs true`，python脚本推理设置`request_config = RequestConfig(..., logprobs=True, top_logprobs=2)`，参考[test_logprobs.py](https://github.com/modelscope/ms-swift/blob/main/tests/infer/test_logprobs.py)。

### Q10: 最新版本swift，我在加载qwen2-32b-instruct-awq 量化模型及其lora的时候，使用vllm 提示我加上merge lore true,我加上就报错了，我去掉vllm 加速就能正常推理了，但是速度很慢
qlora训练的模型不支持merge-lora的, 建议lora微调后 merge-lora再量化。

### Q11: vllm会报错，assert factor in rope_scaling
详见qwen2-vl [issue#96](https://github.com/QwenLM/Qwen2.5-VL/issues/96)。

### Q12: vllm作为推理后端的话，模型必须合并以后才能调用吗？
可以不合并，详见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q13: 请问在使用python脚本推理时，如何使用cpu?
设置环境变量，`os.environ['CUDA_VISIBLE_DEVICES'] = '-1'`。

### Q14: 有人遇到过这个问题吗?RuntimeError: "triu_tril_cuda_template" not implemented for'BFloat16'
升级torch,这个版本的torch没实现这个算子。

### Q15: qwen2-audio支持流式推理吗？
支持，详见[issue](https://github.com/modelscope/ms-swift/issues/1653)

### Q16: inference client推理多模态，do_sample在哪里设置？
设置`temperature=0`。

### Q17: ms-swift支持大模型批处理不？
支持的。详见[demo](https://github.com/modelscope/ms-swift/blob/main/examples/infer/demo.py)。

### Q18: ms-swift量化模型的时候，显示内存不足，可以在量化的时候少占用一些资源吗，慢一点没关系。
尝试设置`--device_map cpu`。

### Q19: swift支持对多模态模型量化吗？
支持。

### Q20: 使用GPTQ报错如下，请问是啥原因？
```text
if llm_config['architectures'][0] == 'LlamaForCausalLM':
KeyError: 'architectures'
```
尝试transformers==4.44.*版本。

### Q21: swift infer如何将评估的结果保存到指定文件呢 每次都不知道保存到哪里了
设置`--result_path your_path`，详见[InferArguments](https://github.com/modelscope/ms-swift/blob/main/swift/llm/argument/infer_args.py)。

### Q22: AWQ量化yi-vl-6b出错如下：
```text
TypeError: swift.llm.utils.model.get_model_tokenizer_with_flash_attn() got multiple values for keyword argument 'automodel_class'.
```
请使用gptq量化。

### Q23: 想问一下用swift export对qwen2.5 72B模型进行gptq int4量化，max model length=32768用的是默认值，给的校准数据集有128个样本，但是量化的时候报错了，报错日志是：factorization could not be completed because the input is not positive-definite(the leading minor of order 18145 is not pisitive-definite)。是什么原因？
海森矩阵不正定的问题，试试其他的数据集。

### Q24: 请问批量推理是只能自己编写代码运行吗？不可以按照 sft 那样填脚本参数码
可以，`swift infer --val_dataset xxx --max_batch_size 16 ... `

### Q25: 问一下，swift app推理时，temperature默认是多少的？
默认从generation_config.json中读取。

### Q26: 请问，导出和量化的时候可以多卡吗？
加载模型可以多卡，量化是单卡。

### Q27: swift export的时候传入自定义的template_type,是不是就可以永久改掉template_type了？如果swift export --template_type 自定义,是不是就可以把模型对应的template改掉
不会被修改,swift中的template是定义在swift内部的,不是以jinja方式保存的。

### Q28: awq量化Qwen2VL报错：TypeError: Qwen2VLForConditionalGeneration.__init__() got an unexpected keyword argument 'use_cache'
用`gptq`量化。

### Q29: ddp 推理，infer里面的这个max_batch_size，是指每张卡的batch_size还是总的batch_size
每张卡。

### Q30: 请问swift.inference现在支持messages格式的输入吗？现在看到好像只能用query格式，得到response。数据answer里面已经包含了部分prompt，希望补全answer，应该怎么修改inference
```text
{"messages": [{"role": "system", "content": "<system>"}, {"role": "user", "content": "<query1>"}, {"role": "assistant", "content": "answer1, "}]}
```
用swift3是可以的，参考[examples/infer/demo_agent](https://github.com/modelscope/ms-swift/blob/main/examples/infer/demo_agent.py)。

### Q31: 请问swift infer的时候，如何让结果实时写入result_path，而不是最后一次性写入呢？
```shell
swift infer \
--ckpt_dir model_dir \
--streaming true \
--val_dataset dataset.jsonl \
--result_path result.jsonl
```
`--stream true`，这样可以一条条写，不过是非batch推理的。

### Q32: 我在swift训练推理的时候是有效果的，但是用merge_lora后再通过ollama的api开接口的时候效果就没了
试试transformers加载，swift的template是对齐transformers的。

### Q33: 模型推理的时候如果需要在特定前缀下继续推理的话是设置哪个参数？
参数`--response_prefix`。

### Q34: 一直报这个错怎么改呀？
```text
File "/mnt/workspace/swift/swift/1lm/dataset/preprocessor/core. py", line 69, in _check_messages raise
ValueError(f'assistant_message; {assistant_message}')
ValueError: assistant_message: {'role' :'assistant', 'content': ''}
```
```shell
CUDA_VISIBLE_DEVICES=0 NPROC_PER_NODE=1 MAX_PIXELS=1003520 swift sft --model Qwen/Qwen2.5-VL-7B-Instruct --train_type lora --dataset /mnt/workspace/data.json --deepspeed zero2 --max_length 16384
```
数据集assistant字段为空，如果是推理，把这个空字符串删掉，因为这个会导致训练时nan，会做检查。

### Q35: 推理报错，ImportError: cannot import name 'shard_checkpoint' from 'transformers.modeling_utils' (/usr/local/lib/python3.10/dist-packages/transformers/modeling_utilspy）
尝试卸载autoawq。

### Q36: swift sample的时候，好像不支持batch？好像是for循环一个个例子sample，有点慢
有一个[脚本](https://github.com/modelscope/ms-swift/blob/main/examples/train/rft/rft.py)，可以用多进程对数据集拆分采样。

### Q37: 请问swift支持embedding模型的推理吗？出现如下报错了
```text
[rank0]:[W511 17:18:01.815062493ProcessGroupNCCL.cpp:1250]Warning: WARNING: process group has NOT been destroyed before we destruct Proc essGroupNCCL. On normal program exit, the application should call des troy_process_group to ensure that any pendingNCCL operations have fi nished in this process. In rare cases this process can exit before th is point and block the progress of another member of the process grou p. This constraint has always been present, but this warning has onl y been added since PyTorch 2.4 (function operator( ))
```
embedding模型推理请使用官方模型代码，swift还没支持。

### Q38: swift框架推理支持模型或者张量并行么？训练不会oom，推理时候报oom了
```shell
CUDA_VISIBLE_DEVICES=0,1 \
MAX_PIXELS=1003520 \
swift infer \
    --adapters /path/to/checkpoint-xxx \
    --merge_lora true \
    --infer_backend vllm \
    --load_data_args true \
    --gpu_memory_utilization 0.9 \
    --tensor_parallel_size 2 \
    --max_model_len 32768 \
    --max_new_tokens 15536 \
    --limit_mm_per_prompt '{"image": 8, "video": 2}'
```
```text
Failed: Cuda error /workspace/csrc/custom_all_reduce.cuh:368 'invalid argument'
```
加一下`--disable_custom_all_reduce true`。

### Q39: 请问流式推理支持ddp吗？
流式不支持ddp。

## 部署

### Q1: 如何部署训练后的模型？
`swift deploy --adapters xxx`，见文档[推理和部署](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E6%8E%A8%E7%90%86%E5%92%8C%E9%83%A8%E7%BD%B2.html)。

### Q2: 如何使用vllm部署进行多卡部署？
详见[例子](https://github.com/modelscope/ms-swift/tree/main/examples/deploy)。

### Q3: 请问用vllm部署的时候，客户端怎么传入图片？
详见[客户端例子](https://github.com/modelscope/ms-swift/tree/main/examples/deploy/client/mllm)。

### Q4: 有个问题想问一下，qwen2-7b部署后使用客户端时，调用openai的api要使用client.completions.create，不能使用client.chat.completions.create，但是使用qwen2-7b-instruct-q5_k_m.gguf的时候可以使用client.chat.completions.create，这是为什么呀？
base模型可以用client.chat.completions.create的，不过这个是兼容行为。

### Q5: 使用两张卡用swift deploy启动服务端后，用Ctrl+C退出后，会一直有一个python进程，一直占用一张卡的显存，这是正常现象吗？
需要kill 一下, 这是vllm的问题。

### Q6: 在哪查看模型是否支持lmdeploy或vllm加速？
vllm和lmdeploy分别有自己的模型支持范围，请查看各自官方文档来确定是否可用。

### Q7: 通义千问2.5-数学-7B-Instruct，会偶尔这样一直返回乱码，是什么问题呢？用vllm部署，fp16。
尝试bf16。

### Q8: swift推理服务启动后，交互进行设置的温度之类的配置，如何设置呢？
推理只能启动前设置。部署可以在启动时设置默认，之后在客户端继续设置，覆盖默认。

### Q9: 在本地部署qwen2vl模型，推理后端使用vllm，本地视频怎么传入呢？可以使用 base64 传进去吗？curl调用如何加载视频呢？
base64，详见[mllm客户端例子](https://github.com/modelscope/ms-swift/tree/main/examples/deploy/client/mllm)

### Q10: qwen2-vl部署时报错如下，是vllm的版本不对么？
```text
Unrecognized keys in `rope_scaling`for 'rope_type'='default': {'mrope_section'} Unrecognized keys in `rope_scaling`for 'rope_type'='default': {'mrope_section'}
```
详见[issue](https://github.com/QwenLM/Qwen2.5-VL/issues/209)。

### Q11: 我用swift deploy做推理的时候，想让他输出token的概率，我加了logprobs True，但是它输出null，这个是什么原因呢？
```shell
RAY_memory_monitor_refresh_ms=0 CUDA_VISIBLE_DEVICES=1 nohup swift deploy --ckpt_dir /mnt/workspace/checkpoint_600 --infer_backend vllm --logprobs True --load_data_args false --host 0.0.0.0 --port 8000 &
```
需要客户端传参数，`request_config = RequestConfig(..., logprobs=True, top_logprobs=2)`。

### Q12: wift3.0 部署推理，可以设置请求的超时时间么？如果图片url非法，会等在那里
设置环境变量`TIMEOUT`,默认是300秒。或者`InferClient`中可以传参数。

### Q13: swift部署的模型怎么没法流式生成啊？服务端的stream设为True了，客户端的stream也设为True了，但它就是没法流式生成
客户端控制的，查看[examples/deploy/client](https://github.com/modelscope/ms-swift/tree/main/examples/deploy/client)。

### Q14: swift部署好多模态模型之后，客户端传PIL.Image，有示例没?
看这个[client例子](https://github.com/modelscope/ms-swift/blob/main/examples/deploy/client/mllm/openai_client.py)。

### Q15: 请问 deploy部署时候，设置什么参数可以实现一次输出，输出多个结果呢？
`RequestConfig`参数`n`。

### Q16: 比使用 swift deploy 部署，指定参数为 --infer_backend vllm，直接使用 vllm 部署：vllm serve ，效果差了接近10个点，有人知道什么原因不？
估计是template没对上。

### Q17: 部署命令怎么关闭qwem3的深度思考模式？
查看这个[issue](https://github.com/modelscope/ms-swift/issues/4030)。

### Q18: 请问，我用ms-swift的vllm部署推理，比原生vllm要慢很多，这个是swift框架的问题嘛？
main分支应该默认使用V1 engine了，加一个`VLLM_USE_V1=1`试试，还有是图像分辨率，要对齐一下。

## 评测

### Q1: swift支持的评测集有哪些？
纯文本评测：
```text
'obqa', 'cmb', 'AX_b', 'siqa', 'nq', 'mbpp', 'winogrande', 'mmlu', 'BoolQ', 'cluewsc', 'ocnli', 'lambada',
'CMRC', 'ceval', 'csl', 'cmnli', 'bbh', 'ReCoRD', 'math', 'humaneval', 'eprstmt', 'WSC', 'storycloze',
'MultiRC', 'RTE', 'chid', 'gsm8k', 'AX_g', 'bustm', 'afqmc', 'piqa', 'lcsts', 'strategyqa', 'Xsum', 'agieval',
'ocnli_fc', 'C3', 'tnews', 'race', 'triviaqa', 'CB', 'WiC', 'hellaswag', 'summedits', 'GaokaoBench',
'ARC_e', 'COPA', 'ARC_c', 'DRCD'
```

多模态评测：
```text
'COCO_VAL', 'MME', 'HallusionBench', 'POPE', 'MMBench_DEV_EN', 'MMBench_TEST_EN', 'MMBench_DEV_CN', 'MMBench_TEST_CN',
'MMBench', 'MMBench_CN', 'MMBench_DEV_EN_V11', 'MMBench_TEST_EN_V11', 'MMBench_DEV_CN_V11',
'MMBench_TEST_CN_V11', 'MMBench_V11', 'MMBench_CN_V11', 'SEEDBench_IMG', 'SEEDBench2',
'SEEDBench2_Plus', 'ScienceQA_VAL', 'ScienceQA_TEST', 'MMT-Bench_ALL_MI', 'MMT-Bench_ALL',
'MMT-Bench_VAL_MI', 'MMT-Bench_VAL', 'AesBench_VAL', 'AesBench_TEST', 'CCBench', 'AI2D_TEST', 'MMStar',
'RealWorldQA', 'MLLMGuard_DS', 'BLINK', 'OCRVQA_TEST', 'OCRVQA_TESTCORE', 'TextVQA_VAL', 'DocVQA_VAL',
'DocVQA_TEST', 'InfoVQA_VAL', 'InfoVQA_TEST', 'ChartQA_TEST', 'MathVision', 'MathVision_MINI',
'MMMU_DEV_VAL', 'MMMU_TEST', 'OCRBench', 'MathVista_MINI', 'LLaVABench', 'MMVet', 'MTVQA_TEST',
'MMLongBench_DOC', 'VCR_EN_EASY_500', 'VCR_EN_EASY_100', 'VCR_EN_EASY_ALL', 'VCR_EN_HARD_500',
'VCR_EN_HARD_100', 'VCR_EN_HARD_ALL', 'VCR_ZH_EASY_500', 'VCR_ZH_EASY_100', 'VCR_ZH_EASY_ALL',
'VCR_ZH_HARD_500', 'VCR_ZH_HARD_100', 'VCR_ZH_HARD_ALL', 'MMDU', 'MMBench-Video', 'Video-MME'
```

详见文档[评测](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E8%AF%84%E6%B5%8B.html)。

### Q2: 如何使用自定义评测集？
纯文本、多模态自定义评测集必须和某个官方评测集数据格式（pattern）保持一致，见文档[评测](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E8%AF%84%E6%B5%8B.html)。

### Q3: python3.11环境，评测时mmengine报错
尝试python3.10环境。或先安装全量依赖： `pip3 install evalscope[all]`，再打patch： `pip3 install https://modelscope-open.oss-cn-hangzhou.aliyuncs.com/package/evalscope-0.5.3.post1-py3-none-any.whl`。

### Q4: 官方支持的评测数据集手动下载后，swift eval能配置本地路径评测吗？
先下载评测数据集[eval.zip](https://modelscope.cn/datasets/swift/evalscope_resource/files)，解压后将里面的内容放到 `~/.cache/modelscope/media_resources/evalscope/data`文件夹下；再执行swift eval命令就可以使用本地数据。

### Q5: 自定义评测是不是有bug，把标准例子改成英文，一直都跑不通？
```shell
swift eval --model_type 'qwen2_5-1_5b-instruct' --eval_dataset no --custom_eval_config '/mnt/workspace/test_data/config_eval.json'
```
这是依赖了nltk的包，然后nltk的tokenizer需要下载一个punkt_tab的zip文件，国内有些环境下载不太稳定或者直接失败。已尝试改了代码做兜底，规避这个问题；参考[issue](https://github.com/nltk/nltk/issues/3293)。

### Q6: eval微调后的模型，总是会在固定的百分比停掉，但是vllm服务看着一直是有在正常运行的。模型越大，断开的越早。
`TIMEOUT`环境变量设置为-1。

### Q7: evalscope 支持多模型对比吗？
详见[文档](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/arena.html)。

### Q8: 多模态数据集有没有自定义评估？
多模态自定义评估可以参考[文档](https://evalscope.readthedocs.io/zh-cn/latest/advanced_guides/custom_dataset/index.html)。

### Q9: ms-swift有方法测试qps，延迟，tokens/s吗？
可以尝试使用evalscope的[模型推理性能压测](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/stress_test/index.html)。

### Q10: 评估的时候可不可以控制数据集条数？评估一个mmlu需要一个多小时，也太慢了。
配置参数`--eval_limit`，这里的`--eval_limit`是控制了每个subset的条数，比如mmlu有50多个subset，每个limit10条，那就是500多条。

### Q11: 想请问一下，评测时不是相当于让模型输出一次回答然后检查答案对不对吗，有没有办法可以记录或看到每次完整的回答呢？
ceval这种多选题的评测是通过计算每个选项的logits来得到的，没有输出回答内容；想得到回答内容的话，可以部署模型服务指定api url来评测，这样是通过解析模型输出来评测的，详见[文档](https://evalscope.readthedocs.io/zh-cn/latest/get_started/basic_usage.html#api)，后面这两种可以做成可选项。

### Q12: 我想用evalscope压测一下我的模型，想采用prompt.txt文件的形式，这个文件内容的格式应该是什么样子的呀？
配置line_by_line，详见[文档](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/stress_test/parameters.html#id5)。

### Q13: 使用evalscope perf进行模型推理性能压测，parallel和number这两个参数怎样使用呢？
number是请求的总数量，parallel是并发数量。

### Q14: 问一下评估swift eval里，模型最多生成1024token就结束了，这个如何修改？设置--max_new_tokens 5000，看起来没起作用
swift里面这个参数还没透出，可以使用evalscope来运行，model里面配置max_tokens参考[文档](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/backend/vlmevalkit_backend.html#id6)。

### Q15: 请问evalscope现在支持deepseek-r1 的相关benchmark吗？AIME、MATH-500这样
支持的，这里有[最佳实践](https://evalscope.readthedocs.io/zh-cn/latest/best_practice/deepseek_r1_distill.html)。

### Q16: 想问一下evalscope测评gpqa使用本地路径报错： ValueError: BuildingConfig 'gpqa_extended' not found. Available: ['default']
参数配置如下：
```shell
 --datasets gpqa --dataset-args '{"gpqa": {"local_path": "/mnt/workspace/gpqa"} }'
 ```
数据集如果要下载到本地使用，建议从modelscope上克隆仓库再指定路径。

### Q17: 用evalscope评测arc数据集的时候，报这个错误，这是什么原因呢，用的是加载本地数据路径方式
```text
KeyError: 'RequestId'
```
```shell
--datasets arc --dataset-args '{"arc": {"local_path": "/mnt/workspace/arc"}}'
```
参考[文档](https://evalscope.readthedocs.io/zh-cn/latest/get_started/basic_usage.html#id10)，arc数据集本身需要通过py脚本来下载数据，直接clone仓库不行。

### Q18: 请教一下，想使用opencompass的后端评测，如何从本地加载下载好的数据集？
opencompass后端不支持设置`data_args`。

### Q19: swift eval 来评估模型，--eval_backend OpenCompass不支持自定义数据集吗？
```text
ValueError: eval_dataset: /mnt/workspace/data.jsonl is not supported.
eval_backend: OpenCompass supported datasets: ['C3', 'summedits', 'WiC', 'csl', 'lambada', 'mbpp', 'hellaswag', 'ARC_e', 'math', 'nq', 'race', 'MultiRC', 'cmb', 'ceval', 'GaokaoBench', 'mmlu', 'winogrande', 'tnews', 'triviaqa', 'CB', 'cluewsc', 'humaneval', 'AX_g', 'DRCD', 'RTE', 'ocnli_fc', 'gsm8k', 'obqa', 'ReCoRD', 'Xsum', 'ocnli', 'WSC', 'siqa', 'agieval', 'piqa', 'cmnli', 'cmmlu', 'eprstmt', 'storycloze', 'AX_b', 'afqmc', 'strategyqa', 'bustm', 'BoolQ', 'COPA', 'ARC_c', 'PMMEval', 'chid', 'CMRC', 'lcsts']
```
opencompass不支持自定义数据集，用native可以自定义模式。

### Q20: 我在本地用单张A100运行模型来做evalscope官方文档里的[RAGAS评测任务](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/backend/rageval_backend/ragas.html)时，跑文档中的两个样例花费了10分钟的时间，请问这是正常的么？有没有什么办法可以优化运行速度。
rag评测本身确实比较耗资源，使用本地critic llm确实会慢一些，处理不了batch请求，建议用vllm这样的框架来拉起任务。

### Q21: 用evalscope评测RAG，但是嵌入式模型我也想用 API 方式调用，支持吗？我看文档上没有写
目前embedding模型还没支持API调用，后续会支持。

### Q22: 使用evalscpoe测试本地训练后的模型，测试数据输出是很简单的，但是训练模型的时候数据构造的是推理的方式，这样测试结果就比较低，请问evalscope怎么仅仅使用模型输出里<answer>xxx</answer>里的数据测试？
dataset-args中设置 {"filters": {"remove_until": "</think>"}} ，参考这个[文档](https://evalscope.readthedocs.io/zh-cn/latest/get_started/parameters.html#id3)。设置这个参数，计算指标的时候会去掉`<think>`。

### Q23: evalscope原生是可以生成报告的 其他后端如opencompass是不支持生成报告可视化是吗？
目前只支持native的可视化，其他后端还不支持。

### Q24: 请问一下评测ifeval报这个错是什么原因？
```text
[Errno 20] Not a directory: '/root/nltk_data/tokenizers/punkt_tab.zip/punkt_tab/english/collocations.tab'
```
解压这个文件，`unzip /path/to/nltk_data/tokenizers/punkt_tab.zip`。

### Q25: 请问评测时eval_backend='OpenCompass'，怎么指定离线数据集路径？
查看[数据准备教程](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/backend/opencompass_backend.html#id3)，下载数据集并解压。不用指定`dataset-args`，将数据集文件夹（即data文件夹）放置在当前工作路径下即可。

### Q26: 用evalscope报这个错是什么原因
```text
unzip: cannot find or open /root/nltk_data/tokenizers/punkt_tab.zip, /root/nltk_data/tokenizers/punkt_tab.zip.zip or /root/nltk_data/tokenizers/punkt_tab.zip.ZIP
```
这是在下载nltk的依赖，手动下载[punkt_tab.zip](https://modelscope-open.oss-cn-hangzhou.aliyuncs.com/open_data/nltk_data/punkt_tab.zip)，解压到`~/nltk_data/tokenizers`下面。

### Q27: 为啥纯文本没问题，测多模态我们指定路径了，但他还是检测不到数据集，会去下载？
vlmevalkit流程跟native不一样，会自己下载数据放到`~/LMUData/`下面。

### Q28: 请教下，evalscope的score是如何计算的，这部分有文档说明吗？
请参考这个[issue](https://github.com/modelscope/evalscope/issues/610)。

### Q29: 请问一下swift eval做benchmark评测的时候，是否可以指定llm作为judge, 参数应该怎么传进去？
支持，使用swift得从`extra_eval_args`去传递`judge-model-args`参数，包括`api_key，api_url，model_id`，整体是一个json字符串。
