from datetime import datetime
from copy import deepcopy

import numpy as np
import pandas as pd

from models.ERM import ERM
from models.utils_AOP import Evaluator
from models.Objective_Pert import ObjectivePert

import warnings
warnings.filterwarnings("ignore")

if __name__ == '__main__':
    for varepsilon in [0.2, 0.3, 0.5]:
        delta = 0.05
        # -- exp params
        x_true = np.asarray([0.5, -0.5, 1, -1, 1])
        D = 5
        A_mean = np.asarray([[1, 0.5, 0, 1, 1],
                             [0.5, 0.5, 0, 1, 1],
                             [0, 0, -0.5, 1, 1]])
        # A_mean = np.column_stack([A_mean, A_mean])
        # x_true = np.concatenate([x_true, x_true])
        m, d = A_mean.shape
        A_oper_norm_ub = 3 * A_mean.shape[1] / 5

        exp_param = {'n': None, 'm': m, 'd': d,
                      'x_true': x_true, 'A_mean': A_mean, 'A_oper_norm_ub': A_oper_norm_ub, 'D': D,
                      'loss_func': 'piecewise', # options: l1, piecewise
                      'pieces': np.asarray([[1, 1, 1, 0],
                                           [1, 1, -1, 0],
                                           [1, -1, 1, 0],
                                           [-1, 1, 1, 0],
                                           [1, -1, -1, 0]])}
        loss_func = exp_param['loss_func']

        x_star = ERM(exp_param).Solve_x(30000)
        exp_param['x_star'] = x_star
        cost_optimal = Evaluator(exp_param, 30000).Evaluate(exp_param['x_star'])['cost']

        # -- algo params
        algo_param = {'varepsilon': varepsilon, 'delta': delta,
                      'gpu_on': True,
                      'N_eachdomain_conv': 50}
        gpu_on = algo_param['gpu_on']


        # -- construct tasks
        ns = [500, 400, 300, 200, 150, 100, 50]   # [50, 100, 150, 200, 300, 400, 500, 1000, 3000]
        iter = 100
        tasks = []
        for n in ns:
            if n == 3000:
                algo_param.update({'N_eachdomain_conv': 35})
            elif n == 1000:
                algo_param.update({'N_eachdomain_conv': 40})
            else:
                algo_param.update({'N_eachdomain_conv': 45})
            for iteration in range(iter):
                new_exp_param = deepcopy(exp_param)
                new_exp_param.update({'n': n})

                tasks.append(ObjectivePert(new_exp_param, algo_param))

        # run each exps
        print(f'----in total, {len(ns)*iter} experiments----')
        outputs = []
        for k, task in enumerate(tasks):
            task_return = task.Run()
            outputs.append(task_return)

        time = datetime.now().strftime('%Y%m%d%H%M%S')

        output_df = pd.DataFrame.from_records(outputs)
        output_df['cost_optimal'] = cost_optimal
        output_df['cost_gap%'] = (output_df['cost'] - cost_optimal) / cost_optimal * 100
        output_df['l2_dist_gap%'] = (output_df['l2_dist']) / np.linalg.norm(x_star, 2) * 100
        output_df['method'] = 'OP'
        output_df['varepsilon'], output_df['delta'] = varepsilon, delta
        output_df.to_csv(f'./data/OP_m={m}_d={d}_(varepsilon,delta)=({varepsilon},{delta})_f={loss_func}_{time}_gpu_on={gpu_on}.csv', index=False)

















