MODEL_PATH="MODEL PATH"
FULL_DATA="m5_task1_train,m5_task2_train,m5_task3_train,m5_task4_train,m5_task5_train,m5_task6_train,m5_task7_train,m5_task8_train"
LRS=(3.0e-4)
DATASETS=(
  $FULL_DATA
)
OUTPUT_DIRS=(
  ""
)

conda activate llamafactory

for i in "${!DATASETS[@]}"; do
    DATASET="${DATASETS[$i]}"
    OUTPUT_DIR="${OUTPUT_DIRS[$i]}"
    PREFIX="${PREFIXES[$i]}"
    LR=${LRS[$i]}
    LOG_NAME="log_${PREFIX}_${DATASET}_lr${LR}.txt"
    echo "Training on: $DATASET, LEARNING RATE: $LR SAVED TO: $OUTPUT_DIR"
    llamafactory-cli train \
      --stage sft \
      --do_train true \
      --finetuning_type lora \
      --lora_rank 16 \
      --lora_target "q_proj,k_proj,v_proj,o_proj" \
      --model_name_or_path "$MODEL_PATH" \
      --image_max_pixels 262144 \
      --video_max_pixels 16384 \
      --trust_remote_code true \
      --dataset "$DATASET" \
      --template qwen2_vl \
      --cutoff_len 2048 \
      --overwrite_cache true \
      --preprocessing_num_workers 16 \
      --dataloader_num_workers 4 \
      --output_dir "$OUTPUT_DIR" \
      --logging_steps 10 \
      --save_steps 800 \
      --plot_loss true \
      --overwrite_output_dir true \
      --per_device_train_batch_size 1 \
      --gradient_accumulation_steps 8 \
      --learning_rate "$LR" \
      --num_train_epochs 3 \
      --lr_scheduler_type cosine \
      --warmup_ratio 0.1 \
      --bf16 true \
      --ddp_timeout 180000000
done