# ALE-Bench Experiments

1. Clone the ALE-Bench repository
```sh
git clone https://github.com/SakanaAI/ALE-Bench.git -b v1.0.0 --depth 1
```
2. Replace the [cloud/setup.sh](https://github.com/SakanaAI/ALE-Bench/blob/v1.0.0/cloud/setup.sh) in the cloned ALE-Bench directory with the [setup.sh](setup.sh) in this repository.
3. Start the AWS EC2 instance as described in the ALE-Bench [README](https://github.com/SakanaAI/ALE-Bench/blob/v1.0.0/README.md#cloud-evaluation-with-aws). You may need to set some environment variables to use AWS.
```sh
export AWS_ACCESS_KEY_ID=""
export AWS_SECRET_ACCESS_KEY=""
export AWS_SESSION_TOKEN=""
cd cloud
terraform init
# You can add instance volume for the storage of the experiment results
terraform apply -var "ssh_public_key_path=</path/to/your/key.pub>" -var "aws_key_name=ale-bench" -var "instance_volume_size=256"
```
4. SSH into the instance and upload this repository to `/home/ubuntu/` at the instance.
```sh
ls /home/ubuntu/experiments
# Check if the experiments directory is uploaded
```
5. Run each experiment script in the subdirectories. See the README files in each subdirectory for details.

## Sub Directories
- [baselines/](baselines/)
    One-shot and iterative-refinement experiments.
- [fishylene/](fishylene/)
    ALE-Agent experiments.
- [notebooks/](notebooks/)
    Jupyter notebooks for the visualization of the results.
- [openhands/](openhands/)
    Scaffolding (OpenHands) experiments.
