# OpenAI
## Non-Reasoning Models
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4o-mini-2024-07-18 \
    --exp_dir results/first_accept/gpt-4o-mini_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4o-mini-2024-07-18 \
    --exp_dir results/first_accept/gpt-4o-mini_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4o-mini-2024-07-18 \
    --exp_dir results/first_accept/gpt-4o-mini_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4o-2024-08-06 \
    --exp_dir results/first_accept/gpt-4o_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4o-2024-08-06 \
    --exp_dir results/first_accept/gpt-4o_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4o-2024-08-06 \
    --exp_dir results/first_accept/gpt-4o_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4.1-nano-2025-04-14 \
    --exp_dir results/first_accept/gpt-4.1-nano_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4.1-nano-2025-04-14 \
    --exp_dir results/first_accept/gpt-4.1-nano_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4.1-nano-2025-04-14 \
    --exp_dir results/first_accept/gpt-4.1-nano_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4.1-mini-2025-04-14 \
    --exp_dir results/first_accept/gpt-4.1-mini_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4.1-mini-2025-04-14 \
    --exp_dir results/first_accept/gpt-4.1-mini_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4.1-mini-2025-04-14 \
    --exp_dir results/first_accept/gpt-4.1-mini_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4.1-2025-04-14 \
    --exp_dir results/first_accept/gpt-4.1_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4.1-2025-04-14 \
    --exp_dir results/first_accept/gpt-4.1_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gpt-4.1-2025-04-14 \
    --exp_dir results/first_accept/gpt-4.1_rust

## Reasoning Models
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o1-2024-12-17 --reasoning_effort high \
    --exp_dir results/first_accept/o1-high_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o1-2024-12-17 --reasoning_effort high \
    --exp_dir results/first_accept/o1-high_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o1-2024-12-17 --reasoning_effort high \
    --exp_dir results/first_accept/o1-high_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o3-mini-2025-01-31 --reasoning_effort high \
    --exp_dir results/first_accept/o3-mini-high_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o3-mini-2025-01-31 --reasoning_effort high \
    --exp_dir results/first_accept/o3-mini-high_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o3-mini-2025-01-31 --reasoning_effort high \
    --exp_dir results/first_accept/o3-mini-high_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o3-2025-04-16 --reasoning_effort high \
    --exp_dir results/first_accept/o3-high_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o3-2025-04-16 --reasoning_effort high \
    --exp_dir results/first_accept/o3-high_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o3-2025-04-16 --reasoning_effort high \
    --exp_dir results/first_accept/o3-high_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o4-mini-2025-04-16 --reasoning_effort high \
    --exp_dir results/first_accept/o4-mini-high_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o4-mini-2025-04-16 --reasoning_effort high \
    --exp_dir results/first_accept/o4-mini-high_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_openai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model o4-mini-2025-04-16 --reasoning_effort high \
    --exp_dir results/first_accept/o4-mini-high_rust


# Google Gen AI
## Non-Reasoning Models
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-1.5-flash-8b-001 \
    --exp_dir results/first_accept/gemini-1.5-flash-8b_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-1.5-flash-8b-001 \
    --exp_dir results/first_accept/gemini-1.5-flash-8b_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-1.5-flash-8b-001 \
    --exp_dir results/first_accept/gemini-1.5-flash-8b_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-1.5-flash-002 \
    --exp_dir results/first_accept/gemini-1.5-flash_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-1.5-flash-002 \
    --exp_dir results/first_accept/gemini-1.5-flash_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-1.5-flash-002 \
    --exp_dir results/first_accept/gemini-1.5-flash_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-1.5-pro-002 \
    --exp_dir results/first_accept/gemini-1.5-pro_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-1.5-pro-002 \
    --exp_dir results/first_accept/gemini-1.5-pro_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-1.5-pro-002 \
    --exp_dir results/first_accept/gemini-1.5-pro_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.0-flash-lite-001 \
    --exp_dir results/first_accept/gemini-2.0-flash-lite_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.0-flash-lite-001 \
    --exp_dir results/first_accept/gemini-2.0-flash-lite_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.0-flash-lite-001 \
    --exp_dir results/first_accept/gemini-2.0-flash-lite_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.0-flash-001 \
    --exp_dir results/first_accept/gemini-2.0-flash_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.0-flash-001 \
    --exp_dir results/first_accept/gemini-2.0-flash_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.0-flash-001 \
    --exp_dir results/first_accept/gemini-2.0-flash_rust

## Reasoning Models
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.5-pro-preview-03-25 \
    --exp_dir results/first_accept/gemini-2.5-pro-thinking_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.5-pro-preview-03-25 \
    --exp_dir results/first_accept/gemini-2.5-pro-thinking_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.5-pro-preview-03-25 \
    --exp_dir results/first_accept/gemini-2.5-pro-thinking_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.5-flash-preview-04-17 \
    --exp_dir results/first_accept/gemini-2.5-flash-thinking_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.5-flash-preview-04-17 \
    --exp_dir results/first_accept/gemini-2.5-flash-thinking_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_google_genai_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --model gemini-2.5-flash-preview-04-17 \
    --exp_dir results/first_accept/gemini-2.5-flash-thinking_rust


# Anthropic
## Non-Reasoning Models
cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client bedrock --model us.anthropic.claude-3-5-haiku-20241022-v1:0 --max_tokens 8192 \
    --exp_dir results/first_accept/claude-3.5-haiku_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client bedrock --model us.anthropic.claude-3-5-haiku-20241022-v1:0 --max_tokens 8192 \
    --exp_dir results/first_accept/claude-3.5-haiku_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client bedrock --model us.anthropic.claude-3-5-haiku-20241022-v1:0 --max_tokens 8192 \
    --exp_dir results/first_accept/claude-3.5-haiku_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client bedrock --model us.anthropic.claude-3-5-sonnet-20241022-v2:0 --max_tokens 8192 \
    --exp_dir results/first_accept/claude-3.5-sonnet_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client bedrock --model us.anthropic.claude-3-5-sonnet-20241022-v2:0 --max_tokens 8192 \
    --exp_dir results/first_accept/claude-3.5-sonnet_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client bedrock --model us.anthropic.claude-3-5-sonnet-20241022-v2:0 --max_tokens 8192 \
    --exp_dir results/first_accept/claude-3.5-sonnet_rust

cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --model anthropic/claude-3.7-sonnet --max_tokens 20000 \
    --exp_dir results/first_accept/claude-3.7-sonnet_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --model anthropic/claude-3.7-sonnet --max_tokens 20000 \
    --exp_dir results/first_accept/claude-3.7-sonnet_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --model anthropic/claude-3.7-sonnet --max_tokens 20000 \
    --exp_dir results/first_accept/claude-3.7-sonnet_rust

## Reasoning Models
cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --model anthropic/claude-3.7-sonnet --max_tokens 20000 --thinking_budget 16000 \
    --exp_dir results/first_accept/claude-3.7-sonnet-thinking_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --model anthropic/claude-3.7-sonnet --max_tokens 20000 --thinking_budget 16000 \
    --exp_dir results/first_accept/claude-3.7-sonnet-thinking_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_anthropic_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --model anthropic/claude-3.7-sonnet --max_tokens 20000 --thinking_budget 16000 \
    --exp_dir results/first_accept/claude-3.7-sonnet-thinking_rust


# DeepSeek
## Non-Reasoning Models
cat ../problem_ids.txt | parallel -j 4 \
    python run_deepseek_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --providers Lambda,DeepInfra --model deepseek/deepseek-chat-v3-0324 --temperature 0.3 --max_tokens 8000 \
    --exp_dir results/first_accept/deepseek-v3_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_deepseek_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --providers Lambda,DeepInfra --model deepseek/deepseek-chat-v3-0324 --temperature 0.3 --max_tokens 8000 \
    --exp_dir results/first_accept/deepseek-v3_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_deepseek_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --providers Lambda,DeepInfra --model deepseek/deepseek-chat-v3-0324 --temperature 0.3 --max_tokens 8000 \
    --exp_dir results/first_accept/deepseek-v3_rust

## Reasoning Models
cat ../problem_ids.txt | parallel -j 4 \
    python run_deepseek_model.py --problem_id {} --num_workers 13 --code_language cpp20 \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --providers Lambda,DeepInfra --model deepseek/deepseek-r1 --temperature 0.6 --max_tokens 32768 \
    --exp_dir results/first_accept/deepseek-r1_cpp20
cat ../problem_ids.txt | parallel -j 4 \
    python run_deepseek_model.py --problem_id {} --num_workers 13 --code_language python \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --providers Lambda,DeepInfra --model deepseek/deepseek-r1 --temperature 0.6 --max_tokens 32768 \
    --exp_dir results/first_accept/deepseek-r1_python
cat ../problem_ids.txt | parallel -j 4 \
    python run_deepseek_model.py --problem_id {} --num_workers 13 --code_language rust \
    --first_accept --num_codes 5 --num_no_code_patience 3 --client openrouter --providers Lambda,DeepInfra --model deepseek/deepseek-r1 --temperature 0.6 --max_tokens 32768 \
    --exp_dir results/first_accept/deepseek-r1_rust
