# ALE-Agent

## How to Run

Execute the `aleagent/run.py` script to run a ALE-Agent experiment.

```bash
export GEMINI_API_KEY=<your_gemini_api_key>
uv sync
source .venv/bin/activate
python aleagent/run.py [OPTIONS]
```

### Options

The following options can be specified.

| Option                   | Type    | Default Value                  | Description                                                                 |
| ------------------------ | ------- | ------------------------------ | --------------------------------------------------------------------------- |
| `--problem_id`           | string  | `ahc046`                       | Problem ID for ALE-Bench.                             |
| `--lite_version`         | boolean | `False`                        | Whether to use the Lite version.                                            |
| `--code_language`        | string  | `cpp20`                        | Programming language to use for solution generation.                        |
| `--model`                | string  | `gemini-2.5-pro-preview-03-25` | Name of the language model to use.                                          |
| `--num_steps`            | int     | `10`                           | Number of steps to execute the search.                                      |
| `--num_samples`          | int     | `1`                            | Number of child nodes to generate in a single node expansion.               |
| `--num_trees`            | int     | `2`                            | Number of independent search trees to use in parallel search.               |
| `--num_parallel`         | int     | `4`                            | Number of parallel threads to use for node expansion.                       |
| `--verbose`              | boolean | `False`                        | Whether to enable detailed log output.                                      |
| `--num_workers`          | int     | `16`                           | Number of workers to use in ALE Bench.                                      |
| `--duration`             | int     | `None`                         | Maximum execution time (in minutes). Unlimited if not specified.            |
| `--realtime`             | boolean | `False`                        | Whether to enable real-time mode (skips private evaluation).                |
| `--use_summary`          | boolean | `False`                        | Whether to incorporate a summary into the prompt.                           |
| `--break_on_ac`          | boolean | `False`                        | Whether to stop code generation when an AC (Accepted) is obtained.          |
| `--use_domain_knowledge` | boolean | `False`                        | Whether to use a prompt incorporating domain knowledge for solution generation. |

Please change `--num_workers` according to the number of CPUs on your machine.

**Example:**

```bash
timeout 14400 python aleagent/run.py --problem_id ahc046 --code_language cpp23 --model gemini-2.5-pro-preview-05-06 --num_steps 100 --num_samples 25 --num_trees 4 --num_parallel 100 --verbose --num_workers 50 --duration 240 --realtime --break_on_ac --use_domain_knowledge
```

**ALE-Agent (Base):**

```bash
# Execute
cd /home/ubuntu/experiments/fishylene
cat ../problem_ids_lite.txt | parallel -j 4 \
    timeout 14400 python aleagent/run.py \
    --problem_id {} --lite_version --code_language cpp20 --model gemini-2.5-pro-preview-03-25 --num_workers 13 \
    --num_steps 100 --duration 240 --num_parallel 100 --realtime \
    --num_samples 1 --num_trees 1 --use_summary --break_on_ac --verbose
# Private evaluation
python private_eval.py
# Rename the result directory
mv results results_base
```

**ALE-Agent (Method 1):**

```bash
cd /home/ubuntu/experiments/fishylene
cat ../problem_ids_lite.txt | parallel -j 4 \
    timeout 14400 python aleagent/run.py \
    --problem_id {} --lite_version --code_language cpp20 --model gemini-2.5-pro-preview-03-25 --num_workers 13 \
    --num_steps 100 --duration 240 --num_parallel 100 --realtime \
    --num_samples 1 --num_trees 1 --use_summary --use_domain_knowledge --verbose
# Private evaluation
python private_eval.py
# Rename the result directory
mv results results_method1
```

**ALE-Agent (Method 1 & 2):**

```bash
cd /home/ubuntu/experiments/fishylene
cat ../problem_ids_lite.txt | parallel -j 4 \
    timeout 14400 python aleagent/run.py \
    --problem_id {} --lite_version --code_language cpp20 --model gemini-2.5-pro-preview-03-25 --num_workers 13 \
    --num_steps 100 --duration 240 --num_parallel 100 --realtime \
    --num_samples 30 --num_trees 1 --use_domain_knowledge --verbose
# Private evaluation
python private_eval.py
# Rename the result directory
mv results results_method1_2
```
