import json
from pathlib import Path

import ale_bench


RESULTS_DIR = Path(__file__).resolve().parent / "results"


def main() -> None:
    list_lite_problem_ids = ale_bench.list_problem_ids(lite_version=True)
    for subdir in RESULTS_DIR.iterdir():
        if not subdir.is_dir():
            continue
        problem_id = subdir.name
        if problem_id not in list_lite_problem_ids:
            print(f"Problem ID {problem_id} is not in the list of lite problem IDs.")
            continue
        solution = subdir / "best.cpp"
        if not solution.is_file():
            print(f"Solution file {solution} does not exist.")
            continue
        solution = solution.read_text()
        session = ale_bench.start(problem_id=problem_id, lite_version=True, num_workers=13)
        private_result, rank, performance = session.private_eval(solution, "cpp20")
        json.dump({
            "problem_id": problem_id, "rank": rank, "performance": performance,
            "private_result": private_result.model_dump(),
        }, open(subdir / f"private_result_{problem_id}.json", "w"))
        print(f"[{problem_id}] rank: {rank}, performance: {performance}")


if __name__ == "__main__":
    main()
