# OpenHands experiments scripts

## Setup
1. Ensure that [Openhands (0.34.0)](https://github.com/All-Hands-AI/OpenHands/tree/0.34.0) is cloned at `/home/ubuntu/OpenHands` by the setup script
2. Install ALE-Bench library to the Python virtual environment
```sh
cd /home/ubuntu/OpenHands  # important: install ALE-Bench at the OpenHands directory (not here `/home/ubuntu/experiments/openhands`)
/home/ubuntu/miniforge3/bin/poetry run python -m pip install git+https://github.com/SakanaAI/ALE-Bench.git@v1.0.0
```
3. To build the OpenHands docker image, run once at first and wait for a while:
```sh
cd /home/ubuntu/experiments/openhands  # important: run this at the OpenHands experiment directory (not here `/home/ubuntu/OpenHands`)
/home/ubuntu/.cache/pypoetry/virtualenvs/openhands-ai-VYmZ5gDF-py3.12/bin/python run.py     --problem-id ahc046 --code-language cpp20 --max-time-in-hours 0.05 --config-file ./config_gpt-4.1-mini.toml --name tmp --agent-cls CodeActAgent --max-iterations 1000
rm -rf /home/ubuntu/experiments/openhands/experiments/tmp
```
4. Set your API keys for each LLM config files (`api_key` field in config_*.toml)

## Run
```sh
cd /home/ubuntu/experiments/openhands
# The below python path may be different depending on your environment:
# /home/ubuntu/.cache/pypoetry/virtualenvs/openhands-ai-VYmZ5gDF-py3.12/bin/python
cat ../problem_ids.txt | parallel -j 4 \
    /home/ubuntu/.cache/pypoetry/virtualenvs/openhands-ai-VYmZ5gDF-py3.12/bin/python run.py \
    --problem-id {} --code-language cpp20 --max-time-in-hours 4 \
    --config-file ./config_gpt-4.1-mini.toml --name gpt-4.1-mini-{}_cpp20 \
    --agent-cls CodeActAgent --max-iterations 1000

cat ../problem_ids.txt | parallel -j 4 \
    /home/ubuntu/.cache/pypoetry/virtualenvs/openhands-ai-VYmZ5gDF-py3.12/bin/python run.py \
    --problem-id {} --code-language cpp20 --max-time-in-hours 4 \
    --config-file ./config_o4-mini-high.toml --name o4-mini-high-{}_cpp20 \
    --agent-cls CodeActAgent --max-iterations 1000

cat ../problem_ids.txt | parallel -j 4 \
    /home/ubuntu/.cache/pypoetry/virtualenvs/openhands-ai-VYmZ5gDF-py3.12/bin/python run.py \
    --problem-id {} --code-language cpp20 --max-time-in-hours 4 \
    --config-file ./config_gemini-2.5-pro.toml --name gemini-2.5-pro-thinking-{}_cpp20 \
    --agent-cls CodeActAgent --max-iterations 1000
```
