import pandas as pd

# 读取三个CSV文件
df1 = pd.read_csv('k400_novel_labels.csv')  # 第一个文件，包含id和name
df2 = pd.read_csv('kinetics_400_labels.csv')  # 第二个文件，包含id和name
df3 = pd.read_csv('k400_rephrased.csv')  # 第三个文件，包含id和name

# 使用第一个文件的name检索第二个文件中相同name的id
# 将第二个文件的name列设置为索引以便快速查找
df2_indexed = df2.set_index('name')
# 在第一个文件中添加一个新列，存储从第二个文件找到的对应id
df1['matched_id'] = df1['name'].map(df2_indexed['id'])

# 使用从第二个文件找到的id检索第三个文件中对应的name
# 将第三个文件的id列设置为索引以便快速查找
df3_indexed = df3.set_index('id')
# 在第一个文件中添加一个新列，存储从第三个文件找到的对应name
df1['output_name'] = df1['matched_id'].map(df3_indexed['name'])

# 创建输出DataFrame，只包含第一个文件的id和从第三个文件找到的name
output_df = df1[['id', 'output_name']].copy()
# 重命名列以符合要求
output_df.columns = ['id', 'name']

# 保存到output.csv
output_df.to_csv('output.csv', index=False)

print("处理完成！结果已保存到output.csv")