#!/usr/bin/env bash
if [ -f $1 ]; then
  config=$1
else
  echo "need a config file"
  exit
fi

now=$(date +"%Y%m%d_%H%M%S")
echo 'log_time:' $now

export CUDA_VISIBLE_DEVICES=3,4,5
python -m torch.distributed.launch --master_port 1239 --nproc_per_node=3 --use_env \
         train1.py  --config ${config} --log_time $now
