import torch as th
import torch.nn as nn
import torch.nn.functional as F
import numpy as np

class LMACAgent(nn.Module):
    def __init__(self, input_shape, important_state_dim, args):
        super(LMACAgent, self).__init__()
        self.args = args
        self.important_state_dim = important_state_dim

        self.fc1 = nn.Linear(input_shape, args.hidden_dim)
        if self.args.use_rnn:
            self.rnn = nn.GRUCell(args.hidden_dim, args.hidden_dim)
        else:
            self.rnn = nn.Linear(args.hidden_dim, args.hidden_dim)
        self.fc2 = nn.Linear(args.hidden_dim, args.n_actions)

    def init_hidden(self):
        # make hidden states on same device as model
        return self.fc1.weight.new(1, self.args.hidden_dim).zero_()
    
    def forward(self, inputs ,hidden_state):
        x = F.relu(self.fc1(inputs))
        h_in = hidden_state.reshape(-1, self.args.hidden_dim)
        if self.args.use_rnn:
            h = self.rnn(x, h_in)
        else:
            h = F.relu(self.rnn(x))

        q = self.fc2(h)
        return q, h