from typing import Optional

from pip._internal.models.format_control import FormatControl


class SelectionPreferences:
    

    __slots__ = [
        "allow_yanked",
        "allow_all_prereleases",
        "format_control",
        "prefer_binary",
        "ignore_requires_python",
    ]

    
    
    
    
    def __init__(
        self,
        allow_yanked: bool,
        allow_all_prereleases: bool = False,
        format_control: Optional[FormatControl] = None,
        prefer_binary: bool = False,
        ignore_requires_python: Optional[bool] = None,
    ) -> None:
        
        if ignore_requires_python is None:
            ignore_requires_python = False

        self.allow_yanked = allow_yanked
        self.allow_all_prereleases = allow_all_prereleases
        self.format_control = format_control
        self.prefer_binary = prefer_binary
        self.ignore_requires_python = ignore_requires_python
