

import logging
import os
import sys

__all__ = ["get_path_uid", "stdlib_pkgs", "WINDOWS"]


logger = logging.getLogger(__name__)


def has_tls() -> bool:
    try:
        import _ssl  

        return True
    except ImportError:
        pass

    from pip._vendor.urllib3.util import IS_PYOPENSSL

    return IS_PYOPENSSL


def get_path_uid(path: str) -> int:
    
    if hasattr(os, "O_NOFOLLOW"):
        fd = os.open(path, os.O_RDONLY | os.O_NOFOLLOW)
        file_uid = os.fstat(fd).st_uid
        os.close(fd)
    else:  
        
        if not os.path.islink(path):
            
            file_uid = os.stat(path).st_uid
        else:
            
            raise OSError(f"{path} is a symlink; Will not return uid for symlinks")
    return file_uid







stdlib_pkgs = {"python", "wsgiref", "argparse"}



WINDOWS = sys.platform.startswith("win") or (sys.platform == "cli" and os.name == "nt")
