




from threading import Lock


class BaseCache(object):

    def get(self, key):
        raise NotImplementedError()

    def set(self, key, value, expires=None):
        raise NotImplementedError()

    def delete(self, key):
        raise NotImplementedError()

    def close(self):
        pass


class DictCache(BaseCache):

    def __init__(self, init_dict=None):
        self.lock = Lock()
        self.data = init_dict or {}

    def get(self, key):
        return self.data.get(key, None)

    def set(self, key, value, expires=None):
        with self.lock:
            self.data.update({key: value})

    def delete(self, key):
        with self.lock:
            if key in self.data:
                self.data.pop(key)


class SeparateBodyBaseCache(BaseCache):
    
    def set_body(self, key, body):
        raise NotImplementedError()

    def get_body(self, key):
        
        raise NotImplementedError()
