


import argparse
import sys

from .. import __version__
from ..universaldetector import UniversalDetector


def description_of(lines, name="stdin"):
    
    u = UniversalDetector()
    for line in lines:
        line = bytearray(line)
        u.feed(line)
        
        if u.done:
            break
    u.close()
    result = u.result
    if result["encoding"]:
        return f'{name}: {result["encoding"]} with confidence {result["confidence"]}'
    return f"{name}: no result"


def main(argv=None):
    
    
    parser = argparse.ArgumentParser(
        description="Takes one or more file paths and reports their detected \
                     encodings"
    )
    parser.add_argument(
        "input",
        help="File whose encoding we would like to determine. \
                              (default: stdin)",
        type=argparse.FileType("rb"),
        nargs="*",
        default=[sys.stdin.buffer],
    )
    parser.add_argument(
        "--version", action="version", version=f"%(prog)s {__version__}"
    )
    args = parser.parse_args(argv)

    for f in args.input:
        if f.isatty():
            print(
                "You are running chardetect interactively. Press "
                "CTRL-D twice at the start of a blank line to signal the "
                "end of your input. If you want help, run chardetect "
                "--help\n",
                file=sys.stderr,
            )
        print(description_of(f, f.name))


if __name__ == "__main__":
    main()
