from __future__ import annotations

import os
import sys
from abc import ABC, abstractmethod
from pathlib import Path

if sys.version_info >= (3, 8):  
    from typing import Literal  


class PlatformDirsABC(ABC):
    

    def __init__(
        self,
        appname: str | None = None,
        appauthor: str | None | Literal[False] = None,
        version: str | None = None,
        roaming: bool = False,
        multipath: bool = False,
        opinion: bool = True,
    ):
        
        self.appname = appname  
        self.appauthor = appauthor
        
        self.version = version
        
        self.roaming = roaming
        
        self.multipath = multipath
        
        self.opinion = opinion  

    def _append_app_name_and_version(self, *base: str) -> str:
        params = list(base[1:])
        if self.appname:
            params.append(self.appname)
            if self.version:
                params.append(self.version)
        return os.path.join(base[0], *params)

    @property
    @abstractmethod
    def user_data_dir(self) -> str:
        

    @property
    @abstractmethod
    def site_data_dir(self) -> str:
        

    @property
    @abstractmethod
    def user_config_dir(self) -> str:
        

    @property
    @abstractmethod
    def site_config_dir(self) -> str:
        

    @property
    @abstractmethod
    def user_cache_dir(self) -> str:
        

    @property
    @abstractmethod
    def user_state_dir(self) -> str:
        

    @property
    @abstractmethod
    def user_log_dir(self) -> str:
        

    @property
    @abstractmethod
    def user_documents_dir(self) -> str:
        

    @property
    @abstractmethod
    def user_runtime_dir(self) -> str:
        

    @property
    def user_data_path(self) -> Path:
        
        return Path(self.user_data_dir)

    @property
    def site_data_path(self) -> Path:
        
        return Path(self.site_data_dir)

    @property
    def user_config_path(self) -> Path:
        
        return Path(self.user_config_dir)

    @property
    def site_config_path(self) -> Path:
        
        return Path(self.site_config_dir)

    @property
    def user_cache_path(self) -> Path:
        
        return Path(self.user_cache_dir)

    @property
    def user_state_path(self) -> Path:
        
        return Path(self.user_state_dir)

    @property
    def user_log_path(self) -> Path:
        
        return Path(self.user_log_dir)

    @property
    def user_documents_path(self) -> Path:
        
        return Path(self.user_documents_dir)

    @property
    def user_runtime_path(self) -> Path:
        
        return Path(self.user_runtime_dir)
