from __future__ import annotations

import os

from .api import PlatformDirsABC


class MacOS(PlatformDirsABC):
    

    @property
    def user_data_dir(self) -> str:
        
        return self._append_app_name_and_version(os.path.expanduser("~/Library/Application Support/"))

    @property
    def site_data_dir(self) -> str:
        
        return self._append_app_name_and_version("/Library/Application Support")

    @property
    def user_config_dir(self) -> str:
        
        return self._append_app_name_and_version(os.path.expanduser("~/Library/Preferences/"))

    @property
    def site_config_dir(self) -> str:
        
        return self._append_app_name_and_version("/Library/Preferences")

    @property
    def user_cache_dir(self) -> str:
        
        return self._append_app_name_and_version(os.path.expanduser("~/Library/Caches"))

    @property
    def user_state_dir(self) -> str:
        
        return self.user_data_dir

    @property
    def user_log_dir(self) -> str:
        
        return self._append_app_name_and_version(os.path.expanduser("~/Library/Logs"))

    @property
    def user_documents_dir(self) -> str:
        
        return os.path.expanduser("~/Documents")

    @property
    def user_runtime_dir(self) -> str:
        
        return self._append_app_name_and_version(os.path.expanduser("~/Library/Caches/TemporaryItems"))


__all__ = [
    "MacOS",
]
