


def apply_filters(stream, filters, lexer=None):
    
    def _apply(filter_, stream):
        yield from filter_.filter(lexer, stream)
    for filter_ in filters:
        stream = _apply(filter_, stream)
    return stream


def simplefilter(f):
    
    return type(f.__name__, (FunctionFilter,), {
        '__module__': getattr(f, '__module__'),
        '__doc__': f.__doc__,
        'function': f,
    })


class Filter:
    

    def __init__(self, **options):
        self.options = options

    def filter(self, lexer, stream):
        raise NotImplementedError()


class FunctionFilter(Filter):
    
    function = None

    def __init__(self, **options):
        if not hasattr(self, 'function'):
            raise TypeError('%r used without bound function' %
                            self.__class__.__name__)
        Filter.__init__(self, **options)

    def filter(self, lexer, stream):
        
        yield from self.function(lexer, stream, self.options)
