from pip._internal.distributions.base import AbstractDistribution
from pip._internal.distributions.sdist import SourceDistribution
from pip._internal.distributions.wheel import WheelDistribution
from pip._internal.req.req_install import InstallRequirement


def make_distribution_for_install_requirement(
    install_req: InstallRequirement,
) -> AbstractDistribution:
    
    
    
    if install_req.editable:
        return SourceDistribution(install_req)

    
    if install_req.is_wheel:
        return WheelDistribution(install_req)

    
    return SourceDistribution(install_req)
