from typing import Any, Dict, Sequence

from pip._vendor.packaging.markers import default_environment

from pip import __version__
from pip._internal.req.req_install import InstallRequirement


class InstallationReport:
    def __init__(self, install_requirements: Sequence[InstallRequirement]):
        self._install_requirements = install_requirements

    @classmethod
    def _install_req_to_dict(cls, ireq: InstallRequirement) -> Dict[str, Any]:
        assert ireq.download_info, f"No download_info for {ireq}"
        res = {
            
            
            
            
            "download_info": ireq.download_info.to_dict(),
            
            
            
            "is_direct": bool(ireq.original_link),
            
            
            
            "requested": ireq.user_supplied,
            
            
            "metadata": ireq.get_dist().metadata_dict,
        }
        if ireq.user_supplied and ireq.extras:
            
            res["requested_extras"] = list(sorted(ireq.extras))
        return res

    def to_dict(self) -> Dict[str, Any]:
        return {
            "version": "0",
            "pip_version": __version__,
            "install": [
                self._install_req_to_dict(ireq) for ireq in self._install_requirements
            ],
            
            
            
            
            
            
            "environment": default_environment(),
        }
