

import logging
from typing import Any, cast



VERBOSE = 15


class VerboseLogger(logging.Logger):
    

    def verbose(self, msg: str, *args: Any, **kwargs: Any) -> None:
        return self.log(VERBOSE, msg, *args, **kwargs)


def getLogger(name: str) -> VerboseLogger:
    
    return cast(VerboseLogger, logging.getLogger(name))


def init_logging() -> None:
    
    logging.setLoggerClass(VerboseLogger)
    logging.addLevelName(VERBOSE, "VERBOSE")
