


import os
import re
import sys
from typing import Optional

from pip._internal.locations import site_packages, user_site
from pip._internal.utils.virtualenv import (
    running_under_virtualenv,
    virtualenv_no_global,
)

__all__ = [
    "egg_link_path_from_sys_path",
    "egg_link_path_from_location",
]


def _egg_link_name(raw_name: str) -> str:
    
    return re.sub("[^A-Za-z0-9.]+", "-", raw_name) + ".egg-link"


def egg_link_path_from_sys_path(raw_name: str) -> Optional[str]:
    
    egg_link_name = _egg_link_name(raw_name)
    for path_item in sys.path:
        egg_link = os.path.join(path_item, egg_link_name)
        if os.path.isfile(egg_link):
            return egg_link
    return None


def egg_link_path_from_location(raw_name: str) -> Optional[str]:
    
    sites = []
    if running_under_virtualenv():
        sites.append(site_packages)
        if not virtualenv_no_global() and user_site:
            sites.append(user_site)
    else:
        if user_site:
            sites.append(user_site)
        sites.append(site_packages)

    egg_link_name = _egg_link_name(raw_name)
    for site in sites:
        egglink = os.path.join(site, egg_link_name)
        if os.path.isfile(egglink):
            return egglink
    return None
