import functools
import logging
import re
from typing import NewType, Optional, Tuple, cast

from pip._vendor.packaging import specifiers, version
from pip._vendor.packaging.requirements import Requirement

NormalizedExtra = NewType("NormalizedExtra", str)

logger = logging.getLogger(__name__)


def check_requires_python(
    requires_python: Optional[str], version_info: Tuple[int, ...]
) -> bool:
    
    if requires_python is None:
        
        return True
    requires_python_specifier = specifiers.SpecifierSet(requires_python)

    python_version = version.parse(".".join(map(str, version_info)))
    return python_version in requires_python_specifier


@functools.lru_cache(maxsize=512)
def get_requirement(req_string: str) -> Requirement:
    
    
    
    
    
    
    return Requirement(req_string)


def safe_extra(extra: str) -> NormalizedExtra:
    
    return cast(NormalizedExtra, re.sub("[^A-Za-z0-9.-]+", "_", extra).lower())
