
from contextlib import contextmanager
from os.path import abspath, dirname
from os.path import join as pjoin

try:
    import importlib.resources as resources
    try:
        resources.files
    except AttributeError:
        
        def _in_proc_script_path():
            return resources.path(__package__, '_in_process.py')
    else:
        def _in_proc_script_path():
            return resources.as_file(
                resources.files(__package__).joinpath('_in_process.py'))
except ImportError:
    
    @contextmanager
    def _in_proc_script_path():
        yield pjoin(dirname(abspath(__file__)), '_in_process.py')
