# Deep Free Energy Network (FENet)

#### Experts
To train PlaNet experts,  
`python planet/main.py --id planet --env cheetah-run --action-repeat 4`  
To generate 10k experts,  
`python planet/main.py --id expert --env cheetah-run --action-repeat 4 --models results/planet/models_950.pth --checkpoint-experience --test --test-episodes 10000`  
To generate 10k suboptimal experts,  
`python planet/main.py --id sub_expert --env cheetah-run --action-repeat 4 --models results/planet/models_150.pth --checkpoint-experience --test --test-episodes 10000`

#### FENet
To run FENet (ImitationRL),  
`python main.py --id fenet --env cheetah-run --batch-size 25 --experience-replay results/expert`  
- Use `--env walker-walk --action-repeat 2` to run FENet in the walker environment
- Use `--experience-replay results/sub_expert` to run FENet with suboptimal experts
- Add `--sparse-env` to run FENet in sparse environments
- Add `--observation-noise 0.2` to run FENet in noisy environments

To run FENet of other learning strategies,  
- ImitationOnly: `python main.py --id imitation --env cheetah-run --experience-replay results/expert --start-agent 1000`  
- RLOnly: `python main.py --id rl --env cheetah-run --seed-episodes 40 --start-expert 1000`  
- Imitation-pretrained RL: `python main.py --id rlwim --env cheetah-run --seed-episodes 40 --models results/imitation/models_950.pth --start-expert 1000`  

#### Behavioral cloning methods
To run Behavioral Cloning methods,  
`python comparison.py --id feedforward --env cheetah-run --policy-number 0 --experience-replay results/expert`  
- Use `--policy-number 0` to run feedforward policy  
- Use `--policy-number 1` to run recurrent policy  
- Use `--policy-number 2` to run recurrent decoder

#### PlaNet with demonstrations
To run PlaNet with demonstrations,  
`python planet_w_expert/main.py --id planetwd --env cheetah-run --action-repeat 4 --experience-replay results/expert`  


Requirements
------------

- Python 3
- [DeepMind Control Suite](https://github.com/deepmind/dm_control)
- [Gym](https://gym.openai.com/)
- [OpenCV Python](https://pypi.python.org/pypi/opencv-python)
- [Plotly](https://plot.ly/)
- [PyTorch](http://pytorch.org/)

To install all dependencies with Anaconda run `conda env create -f environment.yml` and use `source activate fenet` to activate the environment. 

Acknowledgements
----------------
To train PlaNet experts, We use codes from [https://github.com/Kaixhin/PlaNet](https://github.com/Kaixhin/PlaNet).
