# CROISSANT VALIDATION REPORT
================================================================================
## VALIDATION RESULTS
--------------------------------------------------------------------------------
Starting validation for file: croissant
### JSON Format Validation
✓
The URL returned valid JSON.
### Croissant Schema Validation
✓
The dataset passes Croissant validation.
### Records Generation Test (Optional)
✓
Record set 'default_splits' passed validation.
Record set 'default' passed validation.
## JSON-LD REFERENCE
================================================================================
```json
{
  "@context": {
    "@language": "en",
    "@vocab": "https://schema.org/",
    "arrayShape": "cr:arrayShape",
    "citeAs": "cr:citeAs",
    "column": "cr:column",
    "conformsTo": "dct:conformsTo",
    "cr": "http://mlcommons.org/croissant/",
    "data": {
      "@id": "cr:data",
      "@type": "@json"
    },
    "dataBiases": "cr:dataBiases",
    "dataCollection": "cr:dataCollection",
    "dataType": {
      "@id": "cr:dataType",
      "@type": "@vocab"
    },
    "dct": "http://purl.org/dc/terms/",
    "extract": "cr:extract",
    "field": "cr:field",
    "fileProperty": "cr:fileProperty",
    "fileObject": "cr:fileObject",
    "fileSet": "cr:fileSet",
    "format": "cr:format",
    "includes": "cr:includes",
    "isArray": "cr:isArray",
    "isLiveDataset": "cr:isLiveDataset",
    "jsonPath": "cr:jsonPath",
    "key": "cr:key",
    "md5": "cr:md5",
    "parentField": "cr:parentField",
    "path": "cr:path",
    "personalSensitiveInformation": "cr:personalSensitiveInformation",
    "recordSet": "cr:recordSet",
    "references": "cr:references",
    "regex": "cr:regex",
    "repeated": "cr:repeated",
    "replace": "cr:replace",
    "sc": "https://schema.org/",
    "separator": "cr:separator",
    "source": "cr:source",
    "subField": "cr:subField",
    "transform": "cr:transform",
    "@base": "cr_base_iri/"
  },
  "@type": "sc:Dataset",
  "distribution": [
    {
      "@type": "cr:FileObject",
      "@id": "repo",
      "name": "repo",
      "description": "The Hugging Face git repository.",
      "contentUrl": "https://huggingface.co/datasets/THUIAR/MMLA-Datasets/tree/refs%2Fconvert%2Fparquet",
      "encodingFormat": "git+https",
      "sha256": "https://github.com/mlcommons/croissant/issues/80"
    },
    {
      "@type": "cr:FileSet",
      "@id": "parquet-files-for-config-default",
      "containedIn": {
        "@id": "repo"
      },
      "encodingFormat": "application/x-parquet",
      "includes": "default/*/*.parquet"
    }
  ],
  "recordSet": [
    {
      "@type": "cr:RecordSet",
      "dataType": "cr:Split",
      "key": {
        "@id": "default_splits/split_name"
      },
      "@id": "default_splits",
      "name": "default_splits",
      "description": "Splits for the default config.",
      "field": [
        {
          "@type": "cr:Field",
          "@id": "default_splits/split_name",
          "dataType": "sc:Text"
        }
      ],
      "data": [
        {
          "default_splits/split_name": "train"
        },
        {
          "default_splits/split_name": "validation"
        },
        {
          "default_splits/split_name": "test"
        }
      ]
    },
    {
      "@type": "cr:RecordSet",
      "@id": "default",
      "description": "THUIAR/MMLA-Datasets - 'default' subset\n\nAdditional information:\n- 3 splits: train, validation, test",
      "field": [
        {
          "@type": "cr:Field",
          "@id": "default/split",
          "dataType": "sc:Text",
          "source": {
            "fileSet": {
              "@id": "parquet-files-for-config-default"
            },
            "extract": {
              "fileProperty": "fullpath"
            },
            "transform": {
              "regex": "default/(?:partial-)?(train|validation|test)/.+parquet$"
            }
          },
          "references": {
            "field": {
              "@id": "default_splits/split_name"
            }
          }
        },
        {
          "@type": "cr:Field",
          "@id": "default/id",
          "dataType": "sc:Text",
          "source": {
            "fileSet": {
              "@id": "parquet-files-for-config-default"
            },
            "extract": {
              "column": "id"
            }
          }
        },
        {
          "@type": "cr:Field",
          "@id": "default/text",
          "dataType": "sc:Text",
          "source": {
            "fileSet": {
              "@id": "parquet-files-for-config-default"
            },
            "extract": {
              "column": "text"
            }
          }
        },
        {
          "@type": "cr:Field",
          "@id": "default/label",
          "dataType": "sc:Text",
          "source": {
            "fileSet": {
              "@id": "parquet-files-for-config-default"
            },
            "extract": {
              "column": "label"
            }
          }
        },
        {
          "@type": "cr:Field",
          "@id": "default/dimension",
          "dataType": "sc:Text",
          "source": {
            "fileSet": {
              "@id": "parquet-files-for-config-default"
            },
            "extract": {
              "column": "dimension"
            }
          }
        }
      ]
    }
  ],
  "conformsTo": "http://mlcommons.org/croissant/1.1",
  "name": "MMLA-Datasets",
  "description": "\n\t\n\t\t\n\t\tCan Large Language Models Help Multimodal Language Analysis? MMLA: A Comprehensive Benchmark\n\t\n\n\n\t\n\t\t\n\t\t1. Introduction\n\t\n\nMMLA is the first comprehensive multimodal language analysis benchmark for evaluating foundation models. It has the following features:\n\nLarge Scale: 61K+ multimodal samples.\nVarious Sources: 9 datasets.\nThree Modalities: text, video, and audio\nBoth Acting and Real-world Scenarios: films, TV series, YouTube, Vimeo, Bilibili, TED, improvised scripts, etc.\nSix Core\u2026 See the full description on the dataset page: https://huggingface.co/datasets/THUIAR/MMLA-Datasets.",
  "alternateName": [
    "THUIAR/MMLA-Datasets",
    "MMLA"
  ],
  "creator": {
    "@type": "Organization",
    "name": "THUIAR",
    "url": "https://huggingface.co/THUIAR"
  },
  "keywords": [
    "zero-shot-classification",
    "text-classification",
    "text-generation",
    "English",
    "Chinese",
    "cc-by-4.0",
    "10K - 100K",
    "csv",
    "Text",
    "Datasets",
    "Dask",
    "Croissant",
    "Polars",
    "arxiv:2504.16427",
    "\ud83c\uddfa\ud83c\uddf8 Region: US"
  ],
  "license": "https://choosealicense.com/licenses/cc-by-4.0/",
  "url": "https://huggingface.co/datasets/THUIAR/MMLA-Datasets"
}
```